// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabVmOperationSource : IOperationSource<DevTestLabVmResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabVmOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabVmResource IOperationSource<DevTestLabVmResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabVmData.DeserializeDevTestLabVmData(document.RootElement);
            return new DevTestLabVmResource(_client, data);
        }

        async ValueTask<DevTestLabVmResource> IOperationSource<DevTestLabVmResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabVmData.DeserializeDevTestLabVmData(document.RootElement);
            return new DevTestLabVmResource(_client, data);
        }
    }
}
