// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabVirtualNetworkOperationSource : IOperationSource<DevTestLabVirtualNetworkResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabVirtualNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabVirtualNetworkResource IOperationSource<DevTestLabVirtualNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabVirtualNetworkData.DeserializeDevTestLabVirtualNetworkData(document.RootElement);
            return new DevTestLabVirtualNetworkResource(_client, data);
        }

        async ValueTask<DevTestLabVirtualNetworkResource> IOperationSource<DevTestLabVirtualNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabVirtualNetworkData.DeserializeDevTestLabVirtualNetworkData(document.RootElement);
            return new DevTestLabVirtualNetworkResource(_client, data);
        }
    }
}
