// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabServiceFabricOperationSource : IOperationSource<DevTestLabServiceFabricResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabServiceFabricOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabServiceFabricResource IOperationSource<DevTestLabServiceFabricResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabServiceFabricData.DeserializeDevTestLabServiceFabricData(document.RootElement);
            return new DevTestLabServiceFabricResource(_client, data);
        }

        async ValueTask<DevTestLabServiceFabricResource> IOperationSource<DevTestLabServiceFabricResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabServiceFabricData.DeserializeDevTestLabServiceFabricData(document.RootElement);
            return new DevTestLabServiceFabricResource(_client, data);
        }
    }
}
