// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabSecretOperationSource : IOperationSource<DevTestLabSecretResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabSecretOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabSecretResource IOperationSource<DevTestLabSecretResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabSecretData.DeserializeDevTestLabSecretData(document.RootElement);
            return new DevTestLabSecretResource(_client, data);
        }

        async ValueTask<DevTestLabSecretResource> IOperationSource<DevTestLabSecretResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabSecretData.DeserializeDevTestLabSecretData(document.RootElement);
            return new DevTestLabSecretResource(_client, data);
        }
    }
}
