// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabOperationSource : IOperationSource<DevTestLabResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabResource IOperationSource<DevTestLabResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabData.DeserializeDevTestLabData(document.RootElement);
            return new DevTestLabResource(_client, data);
        }

        async ValueTask<DevTestLabResource> IOperationSource<DevTestLabResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabData.DeserializeDevTestLabData(document.RootElement);
            return new DevTestLabResource(_client, data);
        }
    }
}
