// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabFormulaOperationSource : IOperationSource<DevTestLabFormulaResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabFormulaOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabFormulaResource IOperationSource<DevTestLabFormulaResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabFormulaData.DeserializeDevTestLabFormulaData(document.RootElement);
            return new DevTestLabFormulaResource(_client, data);
        }

        async ValueTask<DevTestLabFormulaResource> IOperationSource<DevTestLabFormulaResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabFormulaData.DeserializeDevTestLabFormulaData(document.RootElement);
            return new DevTestLabFormulaResource(_client, data);
        }
    }
}
