// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabEnvironmentOperationSource : IOperationSource<DevTestLabEnvironmentResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabEnvironmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabEnvironmentResource IOperationSource<DevTestLabEnvironmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabEnvironmentData.DeserializeDevTestLabEnvironmentData(document.RootElement);
            return new DevTestLabEnvironmentResource(_client, data);
        }

        async ValueTask<DevTestLabEnvironmentResource> IOperationSource<DevTestLabEnvironmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabEnvironmentData.DeserializeDevTestLabEnvironmentData(document.RootElement);
            return new DevTestLabEnvironmentResource(_client, data);
        }
    }
}
