// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabDiskOperationSource : IOperationSource<DevTestLabDiskResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabDiskOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabDiskResource IOperationSource<DevTestLabDiskResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabDiskData.DeserializeDevTestLabDiskData(document.RootElement);
            return new DevTestLabDiskResource(_client, data);
        }

        async ValueTask<DevTestLabDiskResource> IOperationSource<DevTestLabDiskResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabDiskData.DeserializeDevTestLabDiskData(document.RootElement);
            return new DevTestLabDiskResource(_client, data);
        }
    }
}
