// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs
{
    internal class DevTestLabCustomImageOperationSource : IOperationSource<DevTestLabCustomImageResource>
    {
        private readonly ArmClient _client;

        internal DevTestLabCustomImageOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevTestLabCustomImageResource IOperationSource<DevTestLabCustomImageResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevTestLabCustomImageData.DeserializeDevTestLabCustomImageData(document.RootElement);
            return new DevTestLabCustomImageResource(_client, data);
        }

        async ValueTask<DevTestLabCustomImageResource> IOperationSource<DevTestLabCustomImageResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevTestLabCustomImageData.DeserializeDevTestLabCustomImageData(document.RootElement);
            return new DevTestLabCustomImageResource(_client, data);
        }
    }
}
