// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DevTestLabs.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDevTestLabsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDevTestLabsArmClient"/> class for mocking. </summary>
        protected MockableDevTestLabsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDevTestLabsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDevTestLabsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDevTestLabsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabResource"/> object. </returns>
        public virtual DevTestLabResource GetDevTestLabResource(ResourceIdentifier id)
        {
            DevTestLabResource.ValidateResourceId(id);
            return new DevTestLabResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabGlobalScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabGlobalScheduleResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabGlobalScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabGlobalScheduleResource"/> object. </returns>
        public virtual DevTestLabGlobalScheduleResource GetDevTestLabGlobalScheduleResource(ResourceIdentifier id)
        {
            DevTestLabGlobalScheduleResource.ValidateResourceId(id);
            return new DevTestLabGlobalScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabScheduleResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabScheduleResource"/> object. </returns>
        public virtual DevTestLabScheduleResource GetDevTestLabScheduleResource(ResourceIdentifier id)
        {
            DevTestLabScheduleResource.ValidateResourceId(id);
            return new DevTestLabScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabServiceFabricScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabServiceFabricScheduleResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabServiceFabricScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabServiceFabricScheduleResource"/> object. </returns>
        public virtual DevTestLabServiceFabricScheduleResource GetDevTestLabServiceFabricScheduleResource(ResourceIdentifier id)
        {
            DevTestLabServiceFabricScheduleResource.ValidateResourceId(id);
            return new DevTestLabServiceFabricScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabVmScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabVmScheduleResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabVmScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabVmScheduleResource"/> object. </returns>
        public virtual DevTestLabVmScheduleResource GetDevTestLabVmScheduleResource(ResourceIdentifier id)
        {
            DevTestLabVmScheduleResource.ValidateResourceId(id);
            return new DevTestLabVmScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabArtifactSourceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabArtifactSourceResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabArtifactSourceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabArtifactSourceResource"/> object. </returns>
        public virtual DevTestLabArtifactSourceResource GetDevTestLabArtifactSourceResource(ResourceIdentifier id)
        {
            DevTestLabArtifactSourceResource.ValidateResourceId(id);
            return new DevTestLabArtifactSourceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabArmTemplateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabArmTemplateResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabArmTemplateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabArmTemplateResource"/> object. </returns>
        public virtual DevTestLabArmTemplateResource GetDevTestLabArmTemplateResource(ResourceIdentifier id)
        {
            DevTestLabArmTemplateResource.ValidateResourceId(id);
            return new DevTestLabArmTemplateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabArtifactResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabArtifactResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabArtifactResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabArtifactResource"/> object. </returns>
        public virtual DevTestLabArtifactResource GetDevTestLabArtifactResource(ResourceIdentifier id)
        {
            DevTestLabArtifactResource.ValidateResourceId(id);
            return new DevTestLabArtifactResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabCostResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabCostResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabCostResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabCostResource"/> object. </returns>
        public virtual DevTestLabCostResource GetDevTestLabCostResource(ResourceIdentifier id)
        {
            DevTestLabCostResource.ValidateResourceId(id);
            return new DevTestLabCostResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabCustomImageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabCustomImageResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabCustomImageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabCustomImageResource"/> object. </returns>
        public virtual DevTestLabCustomImageResource GetDevTestLabCustomImageResource(ResourceIdentifier id)
        {
            DevTestLabCustomImageResource.ValidateResourceId(id);
            return new DevTestLabCustomImageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabFormulaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabFormulaResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabFormulaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabFormulaResource"/> object. </returns>
        public virtual DevTestLabFormulaResource GetDevTestLabFormulaResource(ResourceIdentifier id)
        {
            DevTestLabFormulaResource.ValidateResourceId(id);
            return new DevTestLabFormulaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabNotificationChannelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabNotificationChannelResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabNotificationChannelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabNotificationChannelResource"/> object. </returns>
        public virtual DevTestLabNotificationChannelResource GetDevTestLabNotificationChannelResource(ResourceIdentifier id)
        {
            DevTestLabNotificationChannelResource.ValidateResourceId(id);
            return new DevTestLabNotificationChannelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabPolicyResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabPolicyResource"/> object. </returns>
        public virtual DevTestLabPolicyResource GetDevTestLabPolicyResource(ResourceIdentifier id)
        {
            DevTestLabPolicyResource.ValidateResourceId(id);
            return new DevTestLabPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabServiceRunnerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabServiceRunnerResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabServiceRunnerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabServiceRunnerResource"/> object. </returns>
        public virtual DevTestLabServiceRunnerResource GetDevTestLabServiceRunnerResource(ResourceIdentifier id)
        {
            DevTestLabServiceRunnerResource.ValidateResourceId(id);
            return new DevTestLabServiceRunnerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabUserResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabUserResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabUserResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabUserResource"/> object. </returns>
        public virtual DevTestLabUserResource GetDevTestLabUserResource(ResourceIdentifier id)
        {
            DevTestLabUserResource.ValidateResourceId(id);
            return new DevTestLabUserResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabDiskResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabDiskResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabDiskResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabDiskResource"/> object. </returns>
        public virtual DevTestLabDiskResource GetDevTestLabDiskResource(ResourceIdentifier id)
        {
            DevTestLabDiskResource.ValidateResourceId(id);
            return new DevTestLabDiskResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabEnvironmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabEnvironmentResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabEnvironmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabEnvironmentResource"/> object. </returns>
        public virtual DevTestLabEnvironmentResource GetDevTestLabEnvironmentResource(ResourceIdentifier id)
        {
            DevTestLabEnvironmentResource.ValidateResourceId(id);
            return new DevTestLabEnvironmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabSecretResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabSecretResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabSecretResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabSecretResource"/> object. </returns>
        public virtual DevTestLabSecretResource GetDevTestLabSecretResource(ResourceIdentifier id)
        {
            DevTestLabSecretResource.ValidateResourceId(id);
            return new DevTestLabSecretResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabServiceFabricResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabServiceFabricResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabServiceFabricResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabServiceFabricResource"/> object. </returns>
        public virtual DevTestLabServiceFabricResource GetDevTestLabServiceFabricResource(ResourceIdentifier id)
        {
            DevTestLabServiceFabricResource.ValidateResourceId(id);
            return new DevTestLabServiceFabricResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabVmResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabVmResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabVmResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabVmResource"/> object. </returns>
        public virtual DevTestLabVmResource GetDevTestLabVmResource(ResourceIdentifier id)
        {
            DevTestLabVmResource.ValidateResourceId(id);
            return new DevTestLabVmResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevTestLabVirtualNetworkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevTestLabVirtualNetworkResource.CreateResourceIdentifier" /> to create a <see cref="DevTestLabVirtualNetworkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevTestLabVirtualNetworkResource"/> object. </returns>
        public virtual DevTestLabVirtualNetworkResource GetDevTestLabVirtualNetworkResource(ResourceIdentifier id)
        {
            DevTestLabVirtualNetworkResource.ValidateResourceId(id);
            return new DevTestLabVirtualNetworkResource(Client, id);
        }
    }
}
