// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevTestLabs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevTestLabs
{
    /// <summary>
    /// A class representing the DevTestLabVirtualNetwork data model.
    /// A virtual network.
    /// </summary>
    public partial class DevTestLabVirtualNetworkData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabVirtualNetworkData"/>. </summary>
        /// <param name="location"> The location. </param>
        public DevTestLabVirtualNetworkData(AzureLocation location) : base(location)
        {
            AllowedSubnets = new ChangeTrackingList<DevTestLabSubnet>();
            ExternalSubnets = new ChangeTrackingList<DevTestLabExternalSubnet>();
            SubnetOverrides = new ChangeTrackingList<DevTestLabSubnetOverride>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabVirtualNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="allowedSubnets"> The allowed subnets of the virtual network. </param>
        /// <param name="description"> The description of the virtual network. </param>
        /// <param name="externalProviderResourceId"> The Microsoft.Network resource identifier of the virtual network. </param>
        /// <param name="externalSubnets"> The external subnet properties. </param>
        /// <param name="subnetOverrides"> The subnet overrides of the virtual network. </param>
        /// <param name="createdOn"> The creation date of the virtual network. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabVirtualNetworkData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, IList<DevTestLabSubnet> allowedSubnets, string description, string externalProviderResourceId, IReadOnlyList<DevTestLabExternalSubnet> externalSubnets, IList<DevTestLabSubnetOverride> subnetOverrides, DateTimeOffset? createdOn, string provisioningState, Guid? uniqueIdentifier, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            AllowedSubnets = allowedSubnets;
            Description = description;
            ExternalProviderResourceId = externalProviderResourceId;
            ExternalSubnets = externalSubnets;
            SubnetOverrides = subnetOverrides;
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            UniqueIdentifier = uniqueIdentifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabVirtualNetworkData"/> for deserialization. </summary>
        internal DevTestLabVirtualNetworkData()
        {
        }

        /// <summary> The allowed subnets of the virtual network. </summary>
        public IList<DevTestLabSubnet> AllowedSubnets { get; }
        /// <summary> The description of the virtual network. </summary>
        public string Description { get; set; }
        /// <summary> The Microsoft.Network resource identifier of the virtual network. </summary>
        public string ExternalProviderResourceId { get; set; }
        /// <summary> The external subnet properties. </summary>
        public IReadOnlyList<DevTestLabExternalSubnet> ExternalSubnets { get; }
        /// <summary> The subnet overrides of the virtual network. </summary>
        public IList<DevTestLabSubnetOverride> SubnetOverrides { get; }
        /// <summary> The creation date of the virtual network. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The provisioning status of the resource. </summary>
        public string ProvisioningState { get; }
        /// <summary> The unique immutable identifier of a resource (Guid). </summary>
        public Guid? UniqueIdentifier { get; }
    }
}
