// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevTestLabs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevTestLabs
{
    /// <summary>
    /// A class representing the DevTestLabCost data model.
    /// A cost item.
    /// </summary>
    public partial class DevTestLabCostData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostData"/>. </summary>
        /// <param name="location"> The location. </param>
        public DevTestLabCostData(AzureLocation location) : base(location)
        {
            LabCostDetails = new ChangeTrackingList<DevTestLabCostDetails>();
            ResourceCosts = new ChangeTrackingList<DevTestLabResourceCost>();
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="targetCost"> The target cost properties. </param>
        /// <param name="labCostSummary"> The lab cost summary component of the cost data. </param>
        /// <param name="labCostDetails"> The lab cost details component of the cost data. </param>
        /// <param name="resourceCosts"> The resource cost component of the cost data. </param>
        /// <param name="currencyCode"> The currency code of the cost. </param>
        /// <param name="startOn"> The start time of the cost data. </param>
        /// <param name="endOn"> The end time of the cost data. </param>
        /// <param name="createdOn"> The creation date of the cost. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabCostData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, DevTestLabTargetCost targetCost, LabCostSummaryProperties labCostSummary, IReadOnlyList<DevTestLabCostDetails> labCostDetails, IReadOnlyList<DevTestLabResourceCost> resourceCosts, string currencyCode, DateTimeOffset? startOn, DateTimeOffset? endOn, DateTimeOffset? createdOn, string provisioningState, Guid? uniqueIdentifier, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            TargetCost = targetCost;
            LabCostSummary = labCostSummary;
            LabCostDetails = labCostDetails;
            ResourceCosts = resourceCosts;
            CurrencyCode = currencyCode;
            StartOn = startOn;
            EndOn = endOn;
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            UniqueIdentifier = uniqueIdentifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabCostData"/> for deserialization. </summary>
        internal DevTestLabCostData()
        {
        }

        /// <summary> The target cost properties. </summary>
        public DevTestLabTargetCost TargetCost { get; set; }
        /// <summary> The lab cost summary component of the cost data. </summary>
        internal LabCostSummaryProperties LabCostSummary { get; }
        /// <summary> The cost component of the cost item. </summary>
        public double? EstimatedLabCost
        {
            get => LabCostSummary?.EstimatedLabCost;
        }

        /// <summary> The lab cost details component of the cost data. </summary>
        public IReadOnlyList<DevTestLabCostDetails> LabCostDetails { get; }
        /// <summary> The resource cost component of the cost data. </summary>
        public IReadOnlyList<DevTestLabResourceCost> ResourceCosts { get; }
        /// <summary> The currency code of the cost. </summary>
        public string CurrencyCode { get; set; }
        /// <summary> The start time of the cost data. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> The end time of the cost data. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> The creation date of the cost. </summary>
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> The provisioning status of the resource. </summary>
        public string ProvisioningState { get; }
        /// <summary> The unique immutable identifier of a resource (Guid). </summary>
        public Guid? UniqueIdentifier { get; }
    }
}
