// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevTestLabs.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevTestLabs
{
    /// <summary>
    /// A class representing the DevTestLabArtifactSource data model.
    /// Properties of an artifact source.
    /// </summary>
    public partial class DevTestLabArtifactSourceData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactSourceData"/>. </summary>
        /// <param name="location"> The location. </param>
        public DevTestLabArtifactSourceData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactSourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="displayName"> The artifact source's display name. </param>
        /// <param name="uri"> The artifact source's URI. </param>
        /// <param name="sourceType"> The artifact source's type. </param>
        /// <param name="folderPath"> The folder containing artifacts. </param>
        /// <param name="armTemplateFolderPath"> The folder containing Azure Resource Manager templates. </param>
        /// <param name="branchRef"> The artifact source's branch reference. </param>
        /// <param name="securityToken"> The security token to authenticate to the artifact source. </param>
        /// <param name="status"> Indicates if the artifact source is enabled (values: Enabled, Disabled). </param>
        /// <param name="createdOn"> The artifact source's creation date. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevTestLabArtifactSourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string displayName, Uri uri, DevTestLabSourceControlType? sourceType, string folderPath, string armTemplateFolderPath, string branchRef, string securityToken, DevTestLabEnableStatus? status, DateTimeOffset? createdOn, string provisioningState, Guid? uniqueIdentifier, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            DisplayName = displayName;
            Uri = uri;
            SourceType = sourceType;
            FolderPath = folderPath;
            ArmTemplateFolderPath = armTemplateFolderPath;
            BranchRef = branchRef;
            SecurityToken = securityToken;
            Status = status;
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            UniqueIdentifier = uniqueIdentifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabArtifactSourceData"/> for deserialization. </summary>
        internal DevTestLabArtifactSourceData()
        {
        }

        /// <summary> The artifact source's display name. </summary>
        public string DisplayName { get; set; }
        /// <summary> The artifact source's URI. </summary>
        public Uri Uri { get; set; }
        /// <summary> The artifact source's type. </summary>
        public DevTestLabSourceControlType? SourceType { get; set; }
        /// <summary> The folder containing artifacts. </summary>
        public string FolderPath { get; set; }
        /// <summary> The folder containing Azure Resource Manager templates. </summary>
        public string ArmTemplateFolderPath { get; set; }
        /// <summary> The artifact source's branch reference. </summary>
        public string BranchRef { get; set; }
        /// <summary> The security token to authenticate to the artifact source. </summary>
        public string SecurityToken { get; set; }
        /// <summary> Indicates if the artifact source is enabled (values: Enabled, Disabled). </summary>
        public DevTestLabEnableStatus? Status { get; set; }
        /// <summary> The artifact source's creation date. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The provisioning status of the resource. </summary>
        public string ProvisioningState { get; }
        /// <summary> The unique immutable identifier of a resource (Guid). </summary>
        public Guid? UniqueIdentifier { get; }
    }
}
