// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevTestLabs.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDevTestLabsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="defaultStorageAccount"> The lab's default storage account. </param>
        /// <param name="defaultPremiumStorageAccount"> The lab's default premium storage account. </param>
        /// <param name="artifactsStorageAccount"> The lab's artifact storage account. </param>
        /// <param name="premiumDataDiskStorageAccount"> The lab's premium data disk storage account. </param>
        /// <param name="vaultName"> The lab's Key vault. </param>
        /// <param name="labStorageType"> Type of storage used by the lab. It can be either Premium or Standard. Default is Premium. </param>
        /// <param name="mandatoryArtifactsResourceIdsLinux"> The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user. </param>
        /// <param name="mandatoryArtifactsResourceIdsWindows"> The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user. </param>
        /// <param name="createdOn"> The creation date of the lab. </param>
        /// <param name="premiumDataDisks">
        /// The setting to enable usage of premium data disks.
        /// When its value is 'Enabled', creation of standard or premium data disks is allowed.
        /// When its value is 'Disabled', only creation of standard data disks is allowed.
        /// </param>
        /// <param name="environmentPermission"> The access rights to be granted to the user when provisioning an environment. </param>
        /// <param name="announcement"> The properties of any lab announcement associated with this lab. </param>
        /// <param name="support"> The properties of any lab support message associated with this lab. </param>
        /// <param name="vmCreationResourceGroup"> The resource group in which all new lab virtual machines will be created. To let DevTest Labs manage resource group creation, set this value to null. </param>
        /// <param name="publicIPId"> The public IP address for the lab's load balancer. </param>
        /// <param name="loadBalancerId"> The load balancer used to for lab VMs that use shared IP address. </param>
        /// <param name="networkSecurityGroupId"> The Network Security Group attached to the lab VMs Network interfaces to restrict open ports. </param>
        /// <param name="extendedProperties"> Extended properties of the lab used for experimental features. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabData"/> instance for mocking. </returns>
        public static DevTestLabData DevTestLabData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string defaultStorageAccount = null, string defaultPremiumStorageAccount = null, string artifactsStorageAccount = null, string premiumDataDiskStorageAccount = null, string vaultName = null, DevTestLabStorageType? labStorageType = null, IEnumerable<string> mandatoryArtifactsResourceIdsLinux = null, IEnumerable<string> mandatoryArtifactsResourceIdsWindows = null, DateTimeOffset? createdOn = null, DevTestLabPremiumDataDisk? premiumDataDisks = null, DevTestLabEnvironmentPermission? environmentPermission = null, DevTestLabAnnouncement announcement = null, DevTestLabSupport support = null, string vmCreationResourceGroup = null, string publicIPId = null, string loadBalancerId = null, string networkSecurityGroupId = null, IDictionary<string, string> extendedProperties = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();
            mandatoryArtifactsResourceIdsLinux ??= new List<string>();
            mandatoryArtifactsResourceIdsWindows ??= new List<string>();
            extendedProperties ??= new Dictionary<string, string>();

            return new DevTestLabData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                defaultStorageAccount,
                defaultPremiumStorageAccount,
                artifactsStorageAccount,
                premiumDataDiskStorageAccount,
                vaultName,
                labStorageType,
                mandatoryArtifactsResourceIdsLinux?.ToList(),
                mandatoryArtifactsResourceIdsWindows?.ToList(),
                createdOn,
                premiumDataDisks,
                environmentPermission,
                announcement,
                support,
                vmCreationResourceGroup,
                publicIPId,
                loadBalancerId,
                networkSecurityGroupId,
                extendedProperties,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabAnnouncement"/>. </summary>
        /// <param name="title"> The plain text title for the lab announcement. </param>
        /// <param name="markdown"> The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown. </param>
        /// <param name="enabled"> Is the lab announcement active/enabled at this time?. </param>
        /// <param name="expireOn"> The time at which the announcement expires (null for never). </param>
        /// <param name="isExpired"> Has this announcement expired?. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="Models.DevTestLabAnnouncement"/> instance for mocking. </returns>
        public static DevTestLabAnnouncement DevTestLabAnnouncement(string title = null, string markdown = null, DevTestLabEnableStatus? enabled = null, DateTimeOffset? expireOn = null, bool? isExpired = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            return new DevTestLabAnnouncement(
                title,
                markdown,
                enabled,
                expireOn,
                isExpired,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="status"> The status of the schedule (i.e. Enabled, Disabled). </param>
        /// <param name="taskType"> The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart). </param>
        /// <param name="weeklyRecurrence"> If the schedule will occur only some days of the week, specify the weekly recurrence. </param>
        /// <param name="dailyRecurrenceTime"> If the schedule will occur once each day of the week, specify the daily recurrence. </param>
        /// <param name="hourlyRecurrenceMinute"> If the schedule will occur multiple times a day, specify the hourly recurrence. </param>
        /// <param name="timeZoneId"> The time zone ID (e.g. Pacific Standard time). </param>
        /// <param name="notificationSettings"> Notification settings. </param>
        /// <param name="createdOn"> The creation date of the schedule. </param>
        /// <param name="targetResourceId"> The resource ID to which the schedule belongs. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabScheduleData"/> instance for mocking. </returns>
        public static DevTestLabScheduleData DevTestLabScheduleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabEnableStatus? status = null, string taskType = null, DevTestLabWeekDetails weeklyRecurrence = null, string dailyRecurrenceTime = null, int? hourlyRecurrenceMinute = null, string timeZoneId = null, DevTestLabNotificationSettings notificationSettings = null, DateTimeOffset? createdOn = null, string targetResourceId = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabScheduleData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                status,
                taskType,
                weeklyRecurrence,
                dailyRecurrenceTime != null ? new DayDetails(dailyRecurrenceTime, serializedAdditionalRawData: null) : null,
                hourlyRecurrenceMinute != null ? new HourDetails(hourlyRecurrenceMinute, serializedAdditionalRawData: null) : null,
                timeZoneId,
                notificationSettings,
                createdOn,
                targetResourceId,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabArtifactSourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="displayName"> The artifact source's display name. </param>
        /// <param name="uri"> The artifact source's URI. </param>
        /// <param name="sourceType"> The artifact source's type. </param>
        /// <param name="folderPath"> The folder containing artifacts. </param>
        /// <param name="armTemplateFolderPath"> The folder containing Azure Resource Manager templates. </param>
        /// <param name="branchRef"> The artifact source's branch reference. </param>
        /// <param name="securityToken"> The security token to authenticate to the artifact source. </param>
        /// <param name="status"> Indicates if the artifact source is enabled (values: Enabled, Disabled). </param>
        /// <param name="createdOn"> The artifact source's creation date. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabArtifactSourceData"/> instance for mocking. </returns>
        public static DevTestLabArtifactSourceData DevTestLabArtifactSourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string displayName = null, Uri uri = null, DevTestLabSourceControlType? sourceType = null, string folderPath = null, string armTemplateFolderPath = null, string branchRef = null, string securityToken = null, DevTestLabEnableStatus? status = null, DateTimeOffset? createdOn = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabArtifactSourceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                displayName,
                uri,
                sourceType,
                folderPath,
                armTemplateFolderPath,
                branchRef,
                securityToken,
                status,
                createdOn,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabArmTemplateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="displayName"> The display name of the ARM template. </param>
        /// <param name="description"> The description of the ARM template. </param>
        /// <param name="publisher"> The publisher of the ARM template. </param>
        /// <param name="icon"> The URI to the icon of the ARM template. </param>
        /// <param name="contents"> The contents of the ARM template. </param>
        /// <param name="createdOn"> The creation date of the armTemplate. </param>
        /// <param name="parametersValueFilesInfo"> File name and parameter values information from all azuredeploy.*.parameters.json for the ARM template. </param>
        /// <param name="isEnabled"> Whether or not ARM template is enabled for use by lab user. </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabArmTemplateData"/> instance for mocking. </returns>
        public static DevTestLabArmTemplateData DevTestLabArmTemplateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string displayName = null, string description = null, string publisher = null, string icon = null, BinaryData contents = null, DateTimeOffset? createdOn = null, IEnumerable<DevTestLabParametersValueFileInfo> parametersValueFilesInfo = null, bool? isEnabled = null)
        {
            tags ??= new Dictionary<string, string>();
            parametersValueFilesInfo ??= new List<DevTestLabParametersValueFileInfo>();

            return new DevTestLabArmTemplateData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                displayName,
                description,
                publisher,
                icon,
                contents,
                createdOn,
                parametersValueFilesInfo?.ToList(),
                isEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabParametersValueFileInfo"/>. </summary>
        /// <param name="fileName"> File name. </param>
        /// <param name="parametersValueInfo"> Contents of the file. </param>
        /// <returns> A new <see cref="Models.DevTestLabParametersValueFileInfo"/> instance for mocking. </returns>
        public static DevTestLabParametersValueFileInfo DevTestLabParametersValueFileInfo(string fileName = null, BinaryData parametersValueInfo = null)
        {
            return new DevTestLabParametersValueFileInfo(fileName, parametersValueInfo, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabArtifactData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="title"> The artifact's title. </param>
        /// <param name="description"> The artifact's description. </param>
        /// <param name="publisher"> The artifact's publisher. </param>
        /// <param name="filePath"> The file path to the artifact. </param>
        /// <param name="icon"> The URI to the artifact icon. </param>
        /// <param name="targetOSType"> The artifact's target OS. </param>
        /// <param name="parameters"> The artifact's parameters. </param>
        /// <param name="createdOn"> The artifact's creation date. </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabArtifactData"/> instance for mocking. </returns>
        public static DevTestLabArtifactData DevTestLabArtifactData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string title = null, string description = null, string publisher = null, string filePath = null, string icon = null, string targetOSType = null, BinaryData parameters = null, DateTimeOffset? createdOn = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabArtifactData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                title,
                description,
                publisher,
                filePath,
                icon,
                targetOSType,
                parameters,
                createdOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabArmTemplateInfo"/>. </summary>
        /// <param name="template"> The template's contents. </param>
        /// <param name="parameters"> The parameters of the ARM template. </param>
        /// <returns> A new <see cref="Models.DevTestLabArmTemplateInfo"/> instance for mocking. </returns>
        public static DevTestLabArmTemplateInfo DevTestLabArmTemplateInfo(BinaryData template = null, BinaryData parameters = null)
        {
            return new DevTestLabArmTemplateInfo(template, parameters, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabCostData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="targetCost"> The target cost properties. </param>
        /// <param name="estimatedLabCost"> The lab cost summary component of the cost data. </param>
        /// <param name="labCostDetails"> The lab cost details component of the cost data. </param>
        /// <param name="resourceCosts"> The resource cost component of the cost data. </param>
        /// <param name="currencyCode"> The currency code of the cost. </param>
        /// <param name="startOn"> The start time of the cost data. </param>
        /// <param name="endOn"> The end time of the cost data. </param>
        /// <param name="createdOn"> The creation date of the cost. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabCostData"/> instance for mocking. </returns>
        public static DevTestLabCostData DevTestLabCostData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabTargetCost targetCost = null, double? estimatedLabCost = null, IEnumerable<DevTestLabCostDetails> labCostDetails = null, IEnumerable<DevTestLabResourceCost> resourceCosts = null, string currencyCode = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, DateTimeOffset? createdOn = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();
            labCostDetails ??= new List<DevTestLabCostDetails>();
            resourceCosts ??= new List<DevTestLabResourceCost>();

            return new DevTestLabCostData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                targetCost,
                estimatedLabCost != null ? new LabCostSummaryProperties(estimatedLabCost, serializedAdditionalRawData: null) : null,
                labCostDetails?.ToList(),
                resourceCosts?.ToList(),
                currencyCode,
                startOn,
                endOn,
                createdOn,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabCostDetails"/>. </summary>
        /// <param name="on"> The date of the cost item. </param>
        /// <param name="cost"> The cost component of the cost item. </param>
        /// <param name="costType"> The type of the cost. </param>
        /// <returns> A new <see cref="Models.DevTestLabCostDetails"/> instance for mocking. </returns>
        public static DevTestLabCostDetails DevTestLabCostDetails(DateTimeOffset? @on = null, double? cost = null, DevTestLabCostType? costType = null)
        {
            return new DevTestLabCostDetails(@on, cost, costType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabResourceCost"/>. </summary>
        /// <param name="resourceName"> The name of the resource. </param>
        /// <param name="resourceUniqueId"> The unique identifier of the resource. </param>
        /// <param name="resourceCost"> The cost component of the resource cost item. </param>
        /// <param name="resourceType"> The logical resource type (ex. virtualmachine, storageaccount). </param>
        /// <param name="resourceOwner"> The owner of the resource (ex. janedoe@microsoft.com). </param>
        /// <param name="resourcePricingTier"> The category of the resource (ex. Premium_LRS, Standard_DS1). </param>
        /// <param name="resourceStatus"> The status of the resource (ex. Active). </param>
        /// <param name="resourceId"> The ID of the resource. </param>
        /// <param name="externalResourceId"> The ID of the external resource. </param>
        /// <returns> A new <see cref="Models.DevTestLabResourceCost"/> instance for mocking. </returns>
        public static DevTestLabResourceCost DevTestLabResourceCost(string resourceName = null, string resourceUniqueId = null, double? resourceCost = null, string resourceType = null, string resourceOwner = null, string resourcePricingTier = null, string resourceStatus = null, string resourceId = null, string externalResourceId = null)
        {
            return new DevTestLabResourceCost(
                resourceName,
                resourceUniqueId,
                resourceCost,
                resourceType,
                resourceOwner,
                resourcePricingTier,
                resourceStatus,
                resourceId,
                externalResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabCustomImageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="vm"> The virtual machine from which the image is to be created. </param>
        /// <param name="vhd"> The VHD from which the image is to be created. </param>
        /// <param name="description"> The description of the custom image. </param>
        /// <param name="author"> The author of the custom image. </param>
        /// <param name="createdOn"> The creation date of the custom image. </param>
        /// <param name="managedImageId"> The Managed Image Id backing the custom image. </param>
        /// <param name="managedSnapshotId"> The Managed Snapshot Id backing the custom image. </param>
        /// <param name="dataDiskStorageInfo"> Storage information about the data disks present in the custom image. </param>
        /// <param name="customImagePlan"> Storage information about the plan related to this custom image. </param>
        /// <param name="isPlanAuthorized"> Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabCustomImageData"/> instance for mocking. </returns>
        public static DevTestLabCustomImageData DevTestLabCustomImageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabCustomImageVm vm = null, DevTestLabCustomImageVhd vhd = null, string description = null, string author = null, DateTimeOffset? createdOn = null, string managedImageId = null, string managedSnapshotId = null, IEnumerable<DevTestLabDataDiskStorageTypeInfo> dataDiskStorageInfo = null, DevTestLabCustomImagePlan customImagePlan = null, bool? isPlanAuthorized = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();
            dataDiskStorageInfo ??= new List<DevTestLabDataDiskStorageTypeInfo>();

            return new DevTestLabCustomImageData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                vm,
                vhd,
                description,
                author,
                createdOn,
                managedImageId,
                managedSnapshotId,
                dataDiskStorageInfo?.ToList(),
                customImagePlan,
                isPlanAuthorized,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabFormulaData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> The description of the formula. </param>
        /// <param name="author"> The author of the formula. </param>
        /// <param name="osType"> The OS type of the formula. </param>
        /// <param name="createdOn"> The creation date of the formula. </param>
        /// <param name="formulaContent"> The content of the formula. </param>
        /// <param name="labVmId"> Information about a VM from which a formula is to be created. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabFormulaData"/> instance for mocking. </returns>
        public static DevTestLabFormulaData DevTestLabFormulaData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string description = null, string author = null, string osType = null, DateTimeOffset? createdOn = null, DevTestLabVmCreationContent formulaContent = null, string labVmId = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabFormulaData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                description,
                author,
                osType,
                createdOn,
                formulaContent,
                labVmId != null ? new FormulaPropertiesFromVm(labVmId, serializedAdditionalRawData: null) : null,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabScheduleCreationParameter"/>. </summary>
        /// <param name="name"> The name of the virtual machine or environment. </param>
        /// <param name="location"> The location of the new virtual machine or environment. </param>
        /// <param name="tags"> The tags of the resource. </param>
        /// <param name="status"> The status of the schedule (i.e. Enabled, Disabled). </param>
        /// <param name="taskType"> The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart). </param>
        /// <param name="weeklyRecurrence"> If the schedule will occur only some days of the week, specify the weekly recurrence. </param>
        /// <param name="dailyRecurrenceTime"> If the schedule will occur once each day of the week, specify the daily recurrence. </param>
        /// <param name="hourlyRecurrenceMinute"> If the schedule will occur multiple times a day, specify the hourly recurrence. </param>
        /// <param name="timeZoneId"> The time zone ID (e.g. Pacific Standard time). </param>
        /// <param name="notificationSettings"> Notification settings. </param>
        /// <param name="targetResourceId"> The resource ID to which the schedule belongs. </param>
        /// <returns> A new <see cref="Models.DevTestLabScheduleCreationParameter"/> instance for mocking. </returns>
        public static DevTestLabScheduleCreationParameter DevTestLabScheduleCreationParameter(string name = null, AzureLocation? location = null, IDictionary<string, string> tags = null, DevTestLabEnableStatus? status = null, string taskType = null, DevTestLabWeekDetails weeklyRecurrence = null, string dailyRecurrenceTime = null, int? hourlyRecurrenceMinute = null, string timeZoneId = null, DevTestLabNotificationSettings notificationSettings = null, ResourceIdentifier targetResourceId = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabScheduleCreationParameter(
                name,
                location,
                tags,
                status,
                taskType,
                weeklyRecurrence,
                dailyRecurrenceTime != null ? new DayDetails(dailyRecurrenceTime, serializedAdditionalRawData: null) : null,
                hourlyRecurrenceMinute != null ? new HourDetails(hourlyRecurrenceMinute, serializedAdditionalRawData: null) : null,
                timeZoneId,
                notificationSettings,
                targetResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabGalleryImage"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="author"> The author of the gallery image. </param>
        /// <param name="createdOn"> The creation date of the gallery image. </param>
        /// <param name="description"> The description of the gallery image. </param>
        /// <param name="imageReference"> The image reference of the gallery image. </param>
        /// <param name="icon"> The icon of the gallery image. </param>
        /// <param name="isEnabled"> Indicates whether this gallery image is enabled. </param>
        /// <param name="planId"> The third party plan that applies to this image. </param>
        /// <param name="isPlanAuthorized"> Indicates if the plan has been authorized for programmatic deployment. </param>
        /// <returns> A new <see cref="Models.DevTestLabGalleryImage"/> instance for mocking. </returns>
        public static DevTestLabGalleryImage DevTestLabGalleryImage(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string author = null, DateTimeOffset? createdOn = null, string description = null, DevTestLabGalleryImageReference imageReference = null, string icon = null, bool? isEnabled = null, string planId = null, bool? isPlanAuthorized = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabGalleryImage(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                author,
                createdOn,
                description,
                imageReference,
                icon,
                isEnabled,
                planId,
                isPlanAuthorized,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabNotificationChannelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="webHookUri"> The webhook URL to send notifications to. </param>
        /// <param name="emailRecipient"> The email recipient to send notifications to (can be a list of semi-colon separated email addresses). </param>
        /// <param name="notificationLocale"> The locale to use when sending a notification (fallback for unsupported languages is EN). </param>
        /// <param name="description"> Description of notification. </param>
        /// <param name="events"> The list of event for which this notification is enabled. </param>
        /// <param name="createdOn"> The creation date of the notification channel. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabNotificationChannelData"/> instance for mocking. </returns>
        public static DevTestLabNotificationChannelData DevTestLabNotificationChannelData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, Uri webHookUri = null, string emailRecipient = null, string notificationLocale = null, string description = null, IEnumerable<DevTestLabNotificationChannelEvent> events = null, DateTimeOffset? createdOn = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();
            events ??= new List<DevTestLabNotificationChannelEvent>();

            return new DevTestLabNotificationChannelData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                webHookUri,
                emailRecipient,
                notificationLocale,
                description,
                events?.ToList(),
                createdOn,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabEvaluatePoliciesResult"/>. </summary>
        /// <param name="results"> Results of evaluating a policy set. </param>
        /// <returns> A new <see cref="Models.DevTestLabEvaluatePoliciesResult"/> instance for mocking. </returns>
        public static DevTestLabEvaluatePoliciesResult DevTestLabEvaluatePoliciesResult(IEnumerable<DevTestLabPolicySetResult> results = null)
        {
            results ??= new List<DevTestLabPolicySetResult>();

            return new DevTestLabEvaluatePoliciesResult(results?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabPolicySetResult"/>. </summary>
        /// <param name="hasError"> A value indicating whether this policy set evaluation has discovered violations. </param>
        /// <param name="policyViolations"> The list of policy violations. </param>
        /// <returns> A new <see cref="Models.DevTestLabPolicySetResult"/> instance for mocking. </returns>
        public static DevTestLabPolicySetResult DevTestLabPolicySetResult(bool? hasError = null, IEnumerable<DevTestLabPolicyViolation> policyViolations = null)
        {
            policyViolations ??= new List<DevTestLabPolicyViolation>();

            return new DevTestLabPolicySetResult(hasError, policyViolations?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabPolicyViolation"/>. </summary>
        /// <param name="code"> The code of the policy violation. </param>
        /// <param name="message"> The message of the policy violation. </param>
        /// <returns> A new <see cref="Models.DevTestLabPolicyViolation"/> instance for mocking. </returns>
        public static DevTestLabPolicyViolation DevTestLabPolicyViolation(string code = null, string message = null)
        {
            return new DevTestLabPolicyViolation(code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> The description of the policy. </param>
        /// <param name="status"> The status of the policy. </param>
        /// <param name="factName"> The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc. </param>
        /// <param name="factData"> The fact data of the policy. </param>
        /// <param name="threshold"> The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy). </param>
        /// <param name="evaluatorType"> The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy). </param>
        /// <param name="createdOn"> The creation date of the policy. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabPolicyData"/> instance for mocking. </returns>
        public static DevTestLabPolicyData DevTestLabPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string description = null, DevTestLabPolicyStatus? status = null, DevTestLabPolicyFactName? factName = null, string factData = null, string threshold = null, DevTestLabPolicyEvaluatorType? evaluatorType = null, DateTimeOffset? createdOn = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabPolicyData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                description,
                status,
                factName,
                factData,
                threshold,
                evaluatorType,
                createdOn,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabServiceRunnerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabServiceRunnerData"/> instance for mocking. </returns>
        public static DevTestLabServiceRunnerData DevTestLabServiceRunnerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabManagedIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabServiceRunnerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabUserData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the user. </param>
        /// <param name="secretStore"> The secret store of the user. </param>
        /// <param name="createdOn"> The creation date of the user profile. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabUserData"/> instance for mocking. </returns>
        public static DevTestLabUserData DevTestLabUserData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabUserIdentity identity = null, DevTestLabUserSecretStore secretStore = null, DateTimeOffset? createdOn = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabUserData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                secretStore,
                createdOn,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabDiskData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="diskType"> The storage type for the disk (i.e. Standard, Premium). </param>
        /// <param name="diskSizeGiB"> The size of the disk in Gibibytes. </param>
        /// <param name="leasedByLabVmId"> The resource ID of the VM to which this disk is leased. </param>
        /// <param name="diskBlobName"> When backed by a blob, the name of the VHD blob without extension. </param>
        /// <param name="diskUri"> When backed by a blob, the URI of underlying blob. </param>
        /// <param name="storageAccountId"> When backed by a blob, the storage account where the blob is. </param>
        /// <param name="createdOn"> The creation date of the disk. </param>
        /// <param name="hostCaching"> The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite). </param>
        /// <param name="managedDiskId"> When backed by managed disk, this is the ID of the compute disk resource. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabDiskData"/> instance for mocking. </returns>
        public static DevTestLabDiskData DevTestLabDiskData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabStorageType? diskType = null, int? diskSizeGiB = null, ResourceIdentifier leasedByLabVmId = null, string diskBlobName = null, Uri diskUri = null, string storageAccountId = null, DateTimeOffset? createdOn = null, string hostCaching = null, ResourceIdentifier managedDiskId = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabDiskData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                diskType,
                diskSizeGiB,
                leasedByLabVmId,
                diskBlobName,
                diskUri,
                storageAccountId,
                createdOn,
                hostCaching,
                managedDiskId,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabEnvironmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="deploymentProperties"> The deployment properties of the environment. </param>
        /// <param name="armTemplateDisplayName"> The display name of the Azure Resource Manager template that produced the environment. </param>
        /// <param name="resourceGroupId"> The identifier of the resource group containing the environment's resources. </param>
        /// <param name="createdByUser"> The creator of the environment. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabEnvironmentData"/> instance for mocking. </returns>
        public static DevTestLabEnvironmentData DevTestLabEnvironmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabEnvironmentDeployment deploymentProperties = null, string armTemplateDisplayName = null, string resourceGroupId = null, string createdByUser = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabEnvironmentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                deploymentProperties,
                armTemplateDisplayName,
                resourceGroupId,
                createdByUser,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabSecretData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="value"> The value of the secret for secret creation. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabSecretData"/> instance for mocking. </returns>
        public static DevTestLabSecretData DevTestLabSecretData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string value = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabSecretData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                value,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabServiceFabricData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="externalServiceFabricId"> The backing service fabric resource's id. </param>
        /// <param name="environmentId"> The resource id of the environment under which the service fabric resource is present. </param>
        /// <param name="applicableSchedule"> The applicable schedule for the virtual machine. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabServiceFabricData"/> instance for mocking. </returns>
        public static DevTestLabServiceFabricData DevTestLabServiceFabricData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string externalServiceFabricId = null, string environmentId = null, DevTestLabApplicableSchedule applicableSchedule = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabServiceFabricData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                externalServiceFabricId,
                environmentId,
                applicableSchedule,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabApplicableSchedule"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="labVmsShutdown"> The auto-shutdown schedule, if one has been set at the lab or lab resource level. </param>
        /// <param name="labVmsStartup"> The auto-startup schedule, if one has been set at the lab or lab resource level. </param>
        /// <returns> A new <see cref="Models.DevTestLabApplicableSchedule"/> instance for mocking. </returns>
        public static DevTestLabApplicableSchedule DevTestLabApplicableSchedule(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevTestLabScheduleData labVmsShutdown = null, DevTestLabScheduleData labVmsStartup = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DevTestLabApplicableSchedule(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                labVmsShutdown,
                labVmsStartup,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabVmData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="notes"> The notes of the virtual machine. </param>
        /// <param name="ownerObjectId"> The object identifier of the owner of the virtual machine. </param>
        /// <param name="ownerUserPrincipalName"> The user principal name of the virtual machine owner. </param>
        /// <param name="createdByUserId"> The object identifier of the creator of the virtual machine. </param>
        /// <param name="createdByUser"> The email address of creator of the virtual machine. </param>
        /// <param name="createdOn"> The creation date of the virtual machine. </param>
        /// <param name="computeId"> The resource identifier (Microsoft.Compute) of the virtual machine. </param>
        /// <param name="customImageId"> The custom image identifier of the virtual machine. </param>
        /// <param name="osType"> The OS type of the virtual machine. </param>
        /// <param name="size"> The size of the virtual machine. </param>
        /// <param name="userName"> The user name of the virtual machine. </param>
        /// <param name="password"> The password of the virtual machine administrator. </param>
        /// <param name="sshKey"> The SSH key of the virtual machine administrator. </param>
        /// <param name="isAuthenticationWithSshKey"> Indicates whether this virtual machine uses an SSH key for authentication. </param>
        /// <param name="fqdn"> The fully-qualified domain name of the virtual machine. </param>
        /// <param name="labSubnetName"> The lab subnet name of the virtual machine. </param>
        /// <param name="labVirtualNetworkId"> The lab virtual network identifier of the virtual machine. </param>
        /// <param name="disallowPublicIPAddress"> Indicates whether the virtual machine is to be created without a public IP address. </param>
        /// <param name="artifacts"> The artifacts to be installed on the virtual machine. </param>
        /// <param name="artifactDeploymentStatus"> The artifact deployment status for the virtual machine. </param>
        /// <param name="galleryImageReference"> The Microsoft Azure Marketplace image reference of the virtual machine. </param>
        /// <param name="planId"> The id of the plan associated with the virtual machine image. </param>
        /// <param name="computeVm"> The compute virtual machine properties. </param>
        /// <param name="networkInterface"> The network interface properties. </param>
        /// <param name="applicableSchedule"> The applicable schedule for the virtual machine. </param>
        /// <param name="expireOn"> The expiration date for VM. </param>
        /// <param name="allowClaim"> Indicates whether another user can take ownership of the virtual machine. </param>
        /// <param name="storageType"> Storage type to use for virtual machine (i.e. Standard, Premium). </param>
        /// <param name="vmCreationSource"> Tells source of creation of lab virtual machine. Output property only. </param>
        /// <param name="environmentId"> The resource ID of the environment that contains this virtual machine, if any. </param>
        /// <param name="dataDiskParameters"> New or existing data disks to attach to the virtual machine after creation. </param>
        /// <param name="scheduleParameters"> Virtual Machine schedules to be created. </param>
        /// <param name="lastKnownPowerState"> Last known compute power state captured in DTL. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabVmData"/> instance for mocking. </returns>
        public static DevTestLabVmData DevTestLabVmData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string notes = null, string ownerObjectId = null, string ownerUserPrincipalName = null, string createdByUserId = null, string createdByUser = null, DateTimeOffset? createdOn = null, ResourceIdentifier computeId = null, string customImageId = null, string osType = null, string size = null, string userName = null, string password = null, string sshKey = null, bool? isAuthenticationWithSshKey = null, string fqdn = null, string labSubnetName = null, ResourceIdentifier labVirtualNetworkId = null, bool? disallowPublicIPAddress = null, IEnumerable<DevTestLabArtifactInstallInfo> artifacts = null, DevTestLabArtifactDeploymentStatus artifactDeploymentStatus = null, DevTestLabGalleryImageReference galleryImageReference = null, string planId = null, ComputeVmProperties computeVm = null, DevTestLabNetworkInterface networkInterface = null, DevTestLabApplicableSchedule applicableSchedule = null, DateTimeOffset? expireOn = null, bool? allowClaim = null, string storageType = null, DevTestLabVmCreationSource? vmCreationSource = null, ResourceIdentifier environmentId = null, IEnumerable<DevTestLabDataDiskProperties> dataDiskParameters = null, IEnumerable<DevTestLabScheduleCreationParameter> scheduleParameters = null, string lastKnownPowerState = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();
            artifacts ??= new List<DevTestLabArtifactInstallInfo>();
            dataDiskParameters ??= new List<DevTestLabDataDiskProperties>();
            scheduleParameters ??= new List<DevTestLabScheduleCreationParameter>();

            return new DevTestLabVmData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                notes,
                ownerObjectId,
                ownerUserPrincipalName,
                createdByUserId,
                createdByUser,
                createdOn,
                computeId,
                customImageId,
                osType,
                size,
                userName,
                password,
                sshKey,
                isAuthenticationWithSshKey,
                fqdn,
                labSubnetName,
                labVirtualNetworkId,
                disallowPublicIPAddress,
                artifacts?.ToList(),
                artifactDeploymentStatus,
                galleryImageReference,
                planId,
                computeVm,
                networkInterface,
                applicableSchedule,
                expireOn,
                allowClaim,
                storageType,
                vmCreationSource,
                environmentId,
                dataDiskParameters?.ToList(),
                scheduleParameters?.ToList(),
                lastKnownPowerState,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabArtifactDeploymentStatus"/>. </summary>
        /// <param name="deploymentStatus"> The deployment status of the artifact. </param>
        /// <param name="artifactsApplied"> The total count of the artifacts that were successfully applied. </param>
        /// <param name="totalArtifacts"> The total count of the artifacts that were tentatively applied. </param>
        /// <returns> A new <see cref="Models.DevTestLabArtifactDeploymentStatus"/> instance for mocking. </returns>
        public static DevTestLabArtifactDeploymentStatus DevTestLabArtifactDeploymentStatus(string deploymentStatus = null, int? artifactsApplied = null, int? totalArtifacts = null)
        {
            return new DevTestLabArtifactDeploymentStatus(deploymentStatus, artifactsApplied, totalArtifacts, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComputeVmProperties"/>. </summary>
        /// <param name="statuses"> Gets the statuses of the virtual machine. </param>
        /// <param name="osType"> Gets the OS type of the virtual machine. </param>
        /// <param name="vmSize"> Gets the size of the virtual machine. </param>
        /// <param name="networkInterfaceId"> Gets the network interface ID of the virtual machine. </param>
        /// <param name="osDiskId"> Gets OS disk blob uri for the virtual machine. </param>
        /// <param name="dataDiskIds"> Gets data disks blob uri for the virtual machine. </param>
        /// <param name="dataDisks"> Gets all data disks attached to the virtual machine. </param>
        /// <returns> A new <see cref="Models.ComputeVmProperties"/> instance for mocking. </returns>
        public static ComputeVmProperties ComputeVmProperties(IEnumerable<ComputeVmInstanceViewStatus> statuses = null, string osType = null, string vmSize = null, string networkInterfaceId = null, string osDiskId = null, IEnumerable<string> dataDiskIds = null, IEnumerable<ComputeDataDisk> dataDisks = null)
        {
            statuses ??= new List<ComputeVmInstanceViewStatus>();
            dataDiskIds ??= new List<string>();
            dataDisks ??= new List<ComputeDataDisk>();

            return new ComputeVmProperties(
                statuses?.ToList(),
                osType,
                vmSize,
                networkInterfaceId,
                osDiskId,
                dataDiskIds?.ToList(),
                dataDisks?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComputeVmInstanceViewStatus"/>. </summary>
        /// <param name="code"> Gets the status Code. </param>
        /// <param name="displayStatus"> Gets the short localizable label for the status. </param>
        /// <param name="message"> Gets the message associated with the status. </param>
        /// <returns> A new <see cref="Models.ComputeVmInstanceViewStatus"/> instance for mocking. </returns>
        public static ComputeVmInstanceViewStatus ComputeVmInstanceViewStatus(string code = null, string displayStatus = null, string message = null)
        {
            return new ComputeVmInstanceViewStatus(code, displayStatus, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ComputeDataDisk"/>. </summary>
        /// <param name="name"> Gets data disk name. </param>
        /// <param name="diskUri"> When backed by a blob, the URI of underlying blob. </param>
        /// <param name="managedDiskId"> When backed by managed disk, this is the ID of the compute disk resource. </param>
        /// <param name="diskSizeGiB"> Gets data disk size in GiB. </param>
        /// <returns> A new <see cref="Models.ComputeDataDisk"/> instance for mocking. </returns>
        public static ComputeDataDisk ComputeDataDisk(string name = null, Uri diskUri = null, string managedDiskId = null, int? diskSizeGiB = null)
        {
            return new ComputeDataDisk(name, diskUri, managedDiskId, diskSizeGiB, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabRdpConnection"/>. </summary>
        /// <param name="contents"> The contents of the .rdp file. </param>
        /// <returns> A new <see cref="Models.DevTestLabRdpConnection"/> instance for mocking. </returns>
        public static DevTestLabRdpConnection DevTestLabRdpConnection(string contents = null)
        {
            return new DevTestLabRdpConnection(contents, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevTestLabs.DevTestLabVirtualNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="allowedSubnets"> The allowed subnets of the virtual network. </param>
        /// <param name="description"> The description of the virtual network. </param>
        /// <param name="externalProviderResourceId"> The Microsoft.Network resource identifier of the virtual network. </param>
        /// <param name="externalSubnets"> The external subnet properties. </param>
        /// <param name="subnetOverrides"> The subnet overrides of the virtual network. </param>
        /// <param name="createdOn"> The creation date of the virtual network. </param>
        /// <param name="provisioningState"> The provisioning status of the resource. </param>
        /// <param name="uniqueIdentifier"> The unique immutable identifier of a resource (Guid). </param>
        /// <returns> A new <see cref="DevTestLabs.DevTestLabVirtualNetworkData"/> instance for mocking. </returns>
        public static DevTestLabVirtualNetworkData DevTestLabVirtualNetworkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<DevTestLabSubnet> allowedSubnets = null, string description = null, string externalProviderResourceId = null, IEnumerable<DevTestLabExternalSubnet> externalSubnets = null, IEnumerable<DevTestLabSubnetOverride> subnetOverrides = null, DateTimeOffset? createdOn = null, string provisioningState = null, Guid? uniqueIdentifier = null)
        {
            tags ??= new Dictionary<string, string>();
            allowedSubnets ??= new List<DevTestLabSubnet>();
            externalSubnets ??= new List<DevTestLabExternalSubnet>();
            subnetOverrides ??= new List<DevTestLabSubnetOverride>();

            return new DevTestLabVirtualNetworkData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                allowedSubnets?.ToList(),
                description,
                externalProviderResourceId,
                externalSubnets?.ToList(),
                subnetOverrides?.ToList(),
                createdOn,
                provisioningState,
                uniqueIdentifier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabExternalSubnet"/>. </summary>
        /// <param name="id"> Gets or sets the identifier. </param>
        /// <param name="name"> Gets or sets the name. </param>
        /// <returns> A new <see cref="Models.DevTestLabExternalSubnet"/> instance for mocking. </returns>
        public static DevTestLabExternalSubnet DevTestLabExternalSubnet(ResourceIdentifier id = null, string name = null)
        {
            return new DevTestLabExternalSubnet(id, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DevTestLabGenerateUploadUriResult"/>. </summary>
        /// <param name="uploadUri"> The upload URI for the VHD. </param>
        /// <returns> A new <see cref="Models.DevTestLabGenerateUploadUriResult"/> instance for mocking. </returns>
        public static DevTestLabGenerateUploadUriResult DevTestLabGenerateUploadUriResult(Uri uploadUri = null)
        {
            return new DevTestLabGenerateUploadUriResult(uploadUri, serializedAdditionalRawData: null);
        }
    }
}
