// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DevTestLabs.Models;

namespace Azure.ResourceManager.DevTestLabs.Samples
{
    public partial class Sample_DevTestLabServiceFabricScheduleCollection
    {
        // ServiceFabricSchedules_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ServiceFabricSchedulesList()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/ServiceFabricSchedules_List.json
            // this example is just showing the usage of "ServiceFabricSchedules_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabServiceFabricResource created on azure
            // for more information of creating DevTestLabServiceFabricResource, please refer to the document of DevTestLabServiceFabricResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string userName = "@me";
            string serviceFabricName = "{serviceFrabicName}";
            ResourceIdentifier devTestLabServiceFabricResourceId = DevTestLabServiceFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, userName, serviceFabricName);
            DevTestLabServiceFabricResource devTestLabServiceFabric = client.GetDevTestLabServiceFabricResource(devTestLabServiceFabricResourceId);

            // get the collection of this DevTestLabServiceFabricScheduleResource
            DevTestLabServiceFabricScheduleCollection collection = devTestLabServiceFabric.GetDevTestLabServiceFabricSchedules();

            // invoke the operation and iterate over the result
            await foreach (DevTestLabServiceFabricScheduleResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevTestLabScheduleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ServiceFabricSchedules_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ServiceFabricSchedulesGet()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/ServiceFabricSchedules_Get.json
            // this example is just showing the usage of "ServiceFabricSchedules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabServiceFabricResource created on azure
            // for more information of creating DevTestLabServiceFabricResource, please refer to the document of DevTestLabServiceFabricResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string userName = "@me";
            string serviceFabricName = "{serviceFrabicName}";
            ResourceIdentifier devTestLabServiceFabricResourceId = DevTestLabServiceFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, userName, serviceFabricName);
            DevTestLabServiceFabricResource devTestLabServiceFabric = client.GetDevTestLabServiceFabricResource(devTestLabServiceFabricResourceId);

            // get the collection of this DevTestLabServiceFabricScheduleResource
            DevTestLabServiceFabricScheduleCollection collection = devTestLabServiceFabric.GetDevTestLabServiceFabricSchedules();

            // invoke the operation
            string name = "{scheduleName}";
            DevTestLabServiceFabricScheduleResource result = await collection.GetAsync(name);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevTestLabScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ServiceFabricSchedules_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ServiceFabricSchedulesGet()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/ServiceFabricSchedules_Get.json
            // this example is just showing the usage of "ServiceFabricSchedules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabServiceFabricResource created on azure
            // for more information of creating DevTestLabServiceFabricResource, please refer to the document of DevTestLabServiceFabricResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string userName = "@me";
            string serviceFabricName = "{serviceFrabicName}";
            ResourceIdentifier devTestLabServiceFabricResourceId = DevTestLabServiceFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, userName, serviceFabricName);
            DevTestLabServiceFabricResource devTestLabServiceFabric = client.GetDevTestLabServiceFabricResource(devTestLabServiceFabricResourceId);

            // get the collection of this DevTestLabServiceFabricScheduleResource
            DevTestLabServiceFabricScheduleCollection collection = devTestLabServiceFabric.GetDevTestLabServiceFabricSchedules();

            // invoke the operation
            string name = "{scheduleName}";
            bool result = await collection.ExistsAsync(name);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ServiceFabricSchedules_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ServiceFabricSchedulesGet()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/ServiceFabricSchedules_Get.json
            // this example is just showing the usage of "ServiceFabricSchedules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabServiceFabricResource created on azure
            // for more information of creating DevTestLabServiceFabricResource, please refer to the document of DevTestLabServiceFabricResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string userName = "@me";
            string serviceFabricName = "{serviceFrabicName}";
            ResourceIdentifier devTestLabServiceFabricResourceId = DevTestLabServiceFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, userName, serviceFabricName);
            DevTestLabServiceFabricResource devTestLabServiceFabric = client.GetDevTestLabServiceFabricResource(devTestLabServiceFabricResourceId);

            // get the collection of this DevTestLabServiceFabricScheduleResource
            DevTestLabServiceFabricScheduleCollection collection = devTestLabServiceFabric.GetDevTestLabServiceFabricSchedules();

            // invoke the operation
            string name = "{scheduleName}";
            NullableResponse<DevTestLabServiceFabricScheduleResource> response = await collection.GetIfExistsAsync(name);
            DevTestLabServiceFabricScheduleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevTestLabScheduleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // ServiceFabricSchedules_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ServiceFabricSchedulesCreateOrUpdate()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/ServiceFabricSchedules_CreateOrUpdate.json
            // this example is just showing the usage of "ServiceFabricSchedules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabServiceFabricResource created on azure
            // for more information of creating DevTestLabServiceFabricResource, please refer to the document of DevTestLabServiceFabricResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string userName = "@me";
            string serviceFabricName = "{serviceFrabicName}";
            ResourceIdentifier devTestLabServiceFabricResourceId = DevTestLabServiceFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, userName, serviceFabricName);
            DevTestLabServiceFabricResource devTestLabServiceFabric = client.GetDevTestLabServiceFabricResource(devTestLabServiceFabricResourceId);

            // get the collection of this DevTestLabServiceFabricScheduleResource
            DevTestLabServiceFabricScheduleCollection collection = devTestLabServiceFabric.GetDevTestLabServiceFabricSchedules();

            // invoke the operation
            string name = "{scheduleName}";
            DevTestLabScheduleData data = new DevTestLabScheduleData(new AzureLocation("{location}"))
            {
                Status = new DevTestLabEnableStatus("{Enabled|Disabled}"),
                TaskType = "{Unknown|LabVmsShutdownTask|LabVmsStartupTask|LabVmReclamationTask|ComputeVmShutdownTask}",
                WeeklyRecurrence = new DevTestLabWeekDetails()
                {
                    Weekdays =
{
"Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"
},
                    Time = "19:00",
                },
                DailyRecurrenceTime = "19:00",
                HourlyRecurrenceMinute = 0,
                TimeZoneId = "Pacific Standard Time",
                NotificationSettings = new DevTestLabNotificationSettings()
                {
                    Status = new DevTestLabEnableStatus("{Enabled|Disabled}"),
                    TimeInMinutes = 15,
                    WebhookUri = new Uri("{webhoolUrl}"),
                    EmailRecipient = "{email}",
                    NotificationLocale = "EN",
                },
                TargetResourceId = "/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.DevTestLab/labs/{labName}/users/{uniqueIdentifier}/servicefabrics/{serviceFrabicName}",
                Tags =
{
["tagName1"] = "tagValue1",
},
            };
            ArmOperation<DevTestLabServiceFabricScheduleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, name, data);
            DevTestLabServiceFabricScheduleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevTestLabScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
