// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DevTestLabs.Models;

namespace Azure.ResourceManager.DevTestLabs.Samples
{
    public partial class Sample_DevTestLabFormulaResource
    {
        // Formulas_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FormulasGet()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Formulas_Get.json
            // this example is just showing the usage of "Formulas_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabFormulaResource created on azure
            // for more information of creating DevTestLabFormulaResource, please refer to the document of DevTestLabFormulaResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string name = "{formulaName}";
            ResourceIdentifier devTestLabFormulaResourceId = DevTestLabFormulaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, name);
            DevTestLabFormulaResource devTestLabFormula = client.GetDevTestLabFormulaResource(devTestLabFormulaResourceId);

            // invoke the operation
            DevTestLabFormulaResource result = await devTestLabFormula.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevTestLabFormulaData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Formulas_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_FormulasDelete()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Formulas_Delete.json
            // this example is just showing the usage of "Formulas_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabFormulaResource created on azure
            // for more information of creating DevTestLabFormulaResource, please refer to the document of DevTestLabFormulaResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string name = "{formulaName}";
            ResourceIdentifier devTestLabFormulaResourceId = DevTestLabFormulaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, name);
            DevTestLabFormulaResource devTestLabFormula = client.GetDevTestLabFormulaResource(devTestLabFormulaResourceId);

            // invoke the operation
            await devTestLabFormula.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Formulas_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_FormulasUpdate()
        {
            // Generated from example definition: specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Formulas_Update.json
            // this example is just showing the usage of "Formulas_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevTestLabFormulaResource created on azure
            // for more information of creating DevTestLabFormulaResource, please refer to the document of DevTestLabFormulaResource
            string subscriptionId = "{subscriptionId}";
            string resourceGroupName = "resourceGroupName";
            string labName = "{labName}";
            string name = "{formulaName}";
            ResourceIdentifier devTestLabFormulaResourceId = DevTestLabFormulaResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, name);
            DevTestLabFormulaResource devTestLabFormula = client.GetDevTestLabFormulaResource(devTestLabFormulaResourceId);

            // invoke the operation
            DevTestLabFormulaPatch patch = new DevTestLabFormulaPatch()
            {
                Tags =
{
["tagName1"] = "tagValue1",
},
            };
            DevTestLabFormulaResource result = await devTestLabFormula.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevTestLabFormulaData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
