// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DevSpaces.Models
{
    [PersistableModelProxy(typeof(UnknownOrchestratorSpecificConnectionDetails))]
    public partial class OrchestratorSpecificConnectionDetails : IUtf8JsonSerializable, IJsonModel<OrchestratorSpecificConnectionDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OrchestratorSpecificConnectionDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OrchestratorSpecificConnectionDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OrchestratorSpecificConnectionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OrchestratorSpecificConnectionDetails)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("instanceType"u8);
            writer.WriteStringValue(InstanceType);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OrchestratorSpecificConnectionDetails IJsonModel<OrchestratorSpecificConnectionDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OrchestratorSpecificConnectionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OrchestratorSpecificConnectionDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOrchestratorSpecificConnectionDetails(document.RootElement, options);
        }

        internal static OrchestratorSpecificConnectionDetails DeserializeOrchestratorSpecificConnectionDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("instanceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Kubernetes": return KubernetesConnectionDetails.DeserializeKubernetesConnectionDetails(element, options);
                }
            }
            return UnknownOrchestratorSpecificConnectionDetails.DeserializeUnknownOrchestratorSpecificConnectionDetails(element, options);
        }

        BinaryData IPersistableModel<OrchestratorSpecificConnectionDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OrchestratorSpecificConnectionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OrchestratorSpecificConnectionDetails)} does not support writing '{options.Format}' format.");
            }
        }

        OrchestratorSpecificConnectionDetails IPersistableModel<OrchestratorSpecificConnectionDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OrchestratorSpecificConnectionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOrchestratorSpecificConnectionDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OrchestratorSpecificConnectionDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OrchestratorSpecificConnectionDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
