// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevSpaces.Models
{
    /// <summary> Parameters for listing connection details of an Azure Dev Spaces Controller. </summary>
    public partial class ListConnectionDetailsContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ListConnectionDetailsContent"/>. </summary>
        /// <param name="targetContainerHostResourceId"> Resource ID of the target container host mapped to the Azure Dev Spaces Controller. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetContainerHostResourceId"/> is null. </exception>
        public ListConnectionDetailsContent(string targetContainerHostResourceId)
        {
            Argument.AssertNotNull(targetContainerHostResourceId, nameof(targetContainerHostResourceId));

            TargetContainerHostResourceId = targetContainerHostResourceId;
        }

        /// <summary> Initializes a new instance of <see cref="ListConnectionDetailsContent"/>. </summary>
        /// <param name="targetContainerHostResourceId"> Resource ID of the target container host mapped to the Azure Dev Spaces Controller. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ListConnectionDetailsContent(string targetContainerHostResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetContainerHostResourceId = targetContainerHostResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ListConnectionDetailsContent"/> for deserialization. </summary>
        internal ListConnectionDetailsContent()
        {
        }

        /// <summary> Resource ID of the target container host mapped to the Azure Dev Spaces Controller. </summary>
        public string TargetContainerHostResourceId { get; }
    }
}
