// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevSpaces.Models
{
    /// <summary> Model representing SKU for Azure Dev Spaces Controller. </summary>
    public partial class DevSpacesSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevSpacesSku"/>. </summary>
        /// <param name="name"> The name of the SKU for Azure Dev Spaces Controller. </param>
        public DevSpacesSku(DevSpacesSkuName name)
        {
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="DevSpacesSku"/>. </summary>
        /// <param name="name"> The name of the SKU for Azure Dev Spaces Controller. </param>
        /// <param name="tier"> The tier of the SKU for Azure Dev Spaces Controller. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevSpacesSku(DevSpacesSkuName name, DevSpacesSkuTier? tier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Tier = tier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevSpacesSku"/> for deserialization. </summary>
        internal DevSpacesSku()
        {
        }

        /// <summary> The name of the SKU for Azure Dev Spaces Controller. </summary>
        public DevSpacesSkuName Name { get; set; }
        /// <summary> The tier of the SKU for Azure Dev Spaces Controller. </summary>
        public DevSpacesSkuTier? Tier { get; set; }
    }
}
