// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevSpaces.Models
{
    /// <summary> Parameters for updating an Azure Dev Spaces Controller. </summary>
    public partial class ControllerPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ControllerPatch"/>. </summary>
        public ControllerPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="ControllerPatch"/>. </summary>
        /// <param name="tags"> Tags for the Azure Dev Spaces Controller. </param>
        /// <param name="targetContainerHostCredentialsBase64"> Credentials of the target container host (base64). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ControllerPatch(IDictionary<string, string> tags, string targetContainerHostCredentialsBase64, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            TargetContainerHostCredentialsBase64 = targetContainerHostCredentialsBase64;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Tags for the Azure Dev Spaces Controller. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Credentials of the target container host (base64). </summary>
        public string TargetContainerHostCredentialsBase64 { get; set; }
    }
}
