// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevSpaces
{
    internal class ControllerOperationSource : IOperationSource<ControllerResource>
    {
        private readonly ArmClient _client;

        internal ControllerOperationSource(ArmClient client)
        {
            _client = client;
        }

        ControllerResource IOperationSource<ControllerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ControllerData.DeserializeControllerData(document.RootElement);
            return new ControllerResource(_client, data);
        }

        async ValueTask<ControllerResource> IOperationSource<ControllerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ControllerData.DeserializeControllerData(document.RootElement);
            return new ControllerResource(_client, data);
        }
    }
}
