// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.DevSpaces.Models;

namespace Azure.ResourceManager.DevSpaces.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableDevSpacesResourceGroupResource : ArmResource
    {
        private ClientDiagnostics _containerHostMappingsClientDiagnostics;
        private ContainerHostMappingsRestOperations _containerHostMappingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableDevSpacesResourceGroupResource"/> class for mocking. </summary>
        protected MockableDevSpacesResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDevSpacesResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDevSpacesResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics ContainerHostMappingsClientDiagnostics => _containerHostMappingsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DevSpaces", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private ContainerHostMappingsRestOperations ContainerHostMappingsRestClient => _containerHostMappingsRestClient ??= new ContainerHostMappingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of ControllerResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of ControllerResources and their operations over a ControllerResource. </returns>
        public virtual ControllerCollection GetControllers()
        {
            return GetCachedClient(client => new ControllerCollection(client, Id));
        }

        /// <summary>
        /// Gets the properties for an Azure Dev Spaces Controller.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/controllers/{name}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Controllers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ControllerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Name of the resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="name"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ControllerResource>> GetControllerAsync(string name, CancellationToken cancellationToken = default)
        {
            return await GetControllers().GetAsync(name, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets the properties for an Azure Dev Spaces Controller.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/controllers/{name}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Controllers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ControllerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="name"> Name of the resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="name"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ControllerResource> GetController(string name, CancellationToken cancellationToken = default)
        {
            return GetControllers().Get(name, cancellationToken);
        }

        /// <summary>
        /// Returns container host mapping object for a container host resource ID if an associated controller exists.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/locations/{location}/checkContainerHostMapping</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContainerHostMappings_GetContainerHostMapping</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the container host. </param>
        /// <param name="containerHostMapping"> The <see cref="ContainerHostMapping"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="containerHostMapping"/> is null. </exception>
        public virtual async Task<Response<ContainerHostMapping>> GetContainerHostMappingContainerHostMappingAsync(AzureLocation location, ContainerHostMapping containerHostMapping, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(containerHostMapping, nameof(containerHostMapping));

            using var scope = ContainerHostMappingsClientDiagnostics.CreateScope("MockableDevSpacesResourceGroupResource.GetContainerHostMappingContainerHostMapping");
            scope.Start();
            try
            {
                var response = await ContainerHostMappingsRestClient.GetContainerHostMappingAsync(Id.SubscriptionId, Id.ResourceGroupName, location, containerHostMapping, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns container host mapping object for a container host resource ID if an associated controller exists.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/locations/{location}/checkContainerHostMapping</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContainerHostMappings_GetContainerHostMapping</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the container host. </param>
        /// <param name="containerHostMapping"> The <see cref="ContainerHostMapping"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="containerHostMapping"/> is null. </exception>
        public virtual Response<ContainerHostMapping> GetContainerHostMappingContainerHostMapping(AzureLocation location, ContainerHostMapping containerHostMapping, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(containerHostMapping, nameof(containerHostMapping));

            using var scope = ContainerHostMappingsClientDiagnostics.CreateScope("MockableDevSpacesResourceGroupResource.GetContainerHostMappingContainerHostMapping");
            scope.Start();
            try
            {
                var response = ContainerHostMappingsRestClient.GetContainerHostMapping(Id.SubscriptionId, Id.ResourceGroupName, location, containerHostMapping, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
