// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DevSpaces.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDevSpacesArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDevSpacesArmClient"/> class for mocking. </summary>
        protected MockableDevSpacesArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDevSpacesArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDevSpacesArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDevSpacesArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ControllerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ControllerResource.CreateResourceIdentifier" /> to create a <see cref="ControllerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ControllerResource"/> object. </returns>
        public virtual ControllerResource GetControllerResource(ResourceIdentifier id)
        {
            ControllerResource.ValidateResourceId(id);
            return new ControllerResource(Client, id);
        }
    }
}
