// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevSpaces.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevSpaces
{
    /// <summary> A class representing the Controller data model. </summary>
    public partial class ControllerData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ControllerData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> Model representing SKU for Azure Dev Spaces Controller. </param>
        /// <param name="targetContainerHostResourceId"> Resource ID of the target container host. </param>
        /// <param name="targetContainerHostCredentialsBase64"> Credentials of the target container host (base64). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sku"/>, <paramref name="targetContainerHostResourceId"/> or <paramref name="targetContainerHostCredentialsBase64"/> is null. </exception>
        public ControllerData(AzureLocation location, DevSpacesSku sku, string targetContainerHostResourceId, string targetContainerHostCredentialsBase64) : base(location)
        {
            Argument.AssertNotNull(sku, nameof(sku));
            Argument.AssertNotNull(targetContainerHostResourceId, nameof(targetContainerHostResourceId));
            Argument.AssertNotNull(targetContainerHostCredentialsBase64, nameof(targetContainerHostCredentialsBase64));

            Sku = sku;
            TargetContainerHostResourceId = targetContainerHostResourceId;
            TargetContainerHostCredentialsBase64 = targetContainerHostCredentialsBase64;
        }

        /// <summary> Initializes a new instance of <see cref="ControllerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> Model representing SKU for Azure Dev Spaces Controller. </param>
        /// <param name="provisioningState"> Provisioning state of the Azure Dev Spaces Controller. </param>
        /// <param name="hostSuffix"> DNS suffix for public endpoints running in the Azure Dev Spaces Controller. </param>
        /// <param name="dataPlaneFqdn"> DNS name for accessing DataPlane services. </param>
        /// <param name="targetContainerHostApiServerFqdn"> DNS of the target container host's API server. </param>
        /// <param name="targetContainerHostResourceId"> Resource ID of the target container host. </param>
        /// <param name="targetContainerHostCredentialsBase64"> Credentials of the target container host (base64). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ControllerData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, DevSpacesSku sku, ProvisioningState? provisioningState, string hostSuffix, string dataPlaneFqdn, string targetContainerHostApiServerFqdn, string targetContainerHostResourceId, string targetContainerHostCredentialsBase64, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            ProvisioningState = provisioningState;
            HostSuffix = hostSuffix;
            DataPlaneFqdn = dataPlaneFqdn;
            TargetContainerHostApiServerFqdn = targetContainerHostApiServerFqdn;
            TargetContainerHostResourceId = targetContainerHostResourceId;
            TargetContainerHostCredentialsBase64 = targetContainerHostCredentialsBase64;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ControllerData"/> for deserialization. </summary>
        internal ControllerData()
        {
        }

        /// <summary> Model representing SKU for Azure Dev Spaces Controller. </summary>
        public DevSpacesSku Sku { get; set; }
        /// <summary> Provisioning state of the Azure Dev Spaces Controller. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> DNS suffix for public endpoints running in the Azure Dev Spaces Controller. </summary>
        public string HostSuffix { get; }
        /// <summary> DNS name for accessing DataPlane services. </summary>
        public string DataPlaneFqdn { get; }
        /// <summary> DNS of the target container host's API server. </summary>
        public string TargetContainerHostApiServerFqdn { get; }
        /// <summary> Resource ID of the target container host. </summary>
        public string TargetContainerHostResourceId { get; set; }
        /// <summary> Credentials of the target container host (base64). </summary>
        public string TargetContainerHostCredentialsBase64 { get; set; }
    }
}
