// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevSpaces.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDevSpacesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ContainerHostMapping"/>. </summary>
        /// <param name="containerHostResourceId"> ARM ID of the Container Host resource. </param>
        /// <param name="mappedControllerResourceId"> ARM ID of the mapped Controller resource. </param>
        /// <returns> A new <see cref="Models.ContainerHostMapping"/> instance for mocking. </returns>
        public static ContainerHostMapping ContainerHostMapping(string containerHostResourceId = null, string mappedControllerResourceId = null)
        {
            return new ContainerHostMapping(containerHostResourceId, mappedControllerResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DevSpaces.ControllerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> Model representing SKU for Azure Dev Spaces Controller. </param>
        /// <param name="provisioningState"> Provisioning state of the Azure Dev Spaces Controller. </param>
        /// <param name="hostSuffix"> DNS suffix for public endpoints running in the Azure Dev Spaces Controller. </param>
        /// <param name="dataPlaneFqdn"> DNS name for accessing DataPlane services. </param>
        /// <param name="targetContainerHostApiServerFqdn"> DNS of the target container host's API server. </param>
        /// <param name="targetContainerHostResourceId"> Resource ID of the target container host. </param>
        /// <param name="targetContainerHostCredentialsBase64"> Credentials of the target container host (base64). </param>
        /// <returns> A new <see cref="DevSpaces.ControllerData"/> instance for mocking. </returns>
        public static ControllerData ControllerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DevSpacesSku sku = null, ProvisioningState? provisioningState = null, string hostSuffix = null, string dataPlaneFqdn = null, string targetContainerHostApiServerFqdn = null, string targetContainerHostResourceId = null, string targetContainerHostCredentialsBase64 = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ControllerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                provisioningState,
                hostSuffix,
                dataPlaneFqdn,
                targetContainerHostApiServerFqdn,
                targetContainerHostResourceId,
                targetContainerHostCredentialsBase64,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ControllerConnectionDetailsList"/>. </summary>
        /// <param name="connectionDetailsList"> List of Azure Dev Spaces Controller connection details. </param>
        /// <returns> A new <see cref="Models.ControllerConnectionDetailsList"/> instance for mocking. </returns>
        public static ControllerConnectionDetailsList ControllerConnectionDetailsList(IEnumerable<ControllerConnectionDetails> connectionDetailsList = null)
        {
            connectionDetailsList ??= new List<ControllerConnectionDetails>();

            return new ControllerConnectionDetailsList(connectionDetailsList?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ControllerConnectionDetails"/>. </summary>
        /// <param name="orchestratorSpecificConnectionDetails">
        /// Base class for types that supply values used to connect to container orchestrators
        /// Please note <see cref="OrchestratorSpecificConnectionDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.KubernetesConnectionDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ControllerConnectionDetails"/> instance for mocking. </returns>
        public static ControllerConnectionDetails ControllerConnectionDetails(OrchestratorSpecificConnectionDetails orchestratorSpecificConnectionDetails = null)
        {
            return new ControllerConnectionDetails(orchestratorSpecificConnectionDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KubernetesConnectionDetails"/>. </summary>
        /// <param name="kubeConfig"> Gets the kubeconfig for the cluster. </param>
        /// <returns> A new <see cref="Models.KubernetesConnectionDetails"/> instance for mocking. </returns>
        public static KubernetesConnectionDetails KubernetesConnectionDetails(string kubeConfig = null)
        {
            return new KubernetesConnectionDetails("Kubernetes", serializedAdditionalRawData: null, kubeConfig);
        }
    }
}
