// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The secret management settings of the machines in the pool. </summary>
    public partial class SecretsManagementSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecretsManagementSettings"/>. </summary>
        /// <param name="observedCertificates"> The list of certificates to install on all machines in the pool. </param>
        /// <param name="keyExportable"> Defines if the key of the certificates should be exportable. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="observedCertificates"/> is null. </exception>
        public SecretsManagementSettings(IEnumerable<Uri> observedCertificates, bool keyExportable)
        {
            Argument.AssertNotNull(observedCertificates, nameof(observedCertificates));

            ObservedCertificates = observedCertificates.ToList();
            KeyExportable = keyExportable;
        }

        /// <summary> Initializes a new instance of <see cref="SecretsManagementSettings"/>. </summary>
        /// <param name="certificateStoreLocation"> Where to store certificates on the machine. </param>
        /// <param name="observedCertificates"> The list of certificates to install on all machines in the pool. </param>
        /// <param name="keyExportable"> Defines if the key of the certificates should be exportable. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecretsManagementSettings(string certificateStoreLocation, IList<Uri> observedCertificates, bool keyExportable, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CertificateStoreLocation = certificateStoreLocation;
            ObservedCertificates = observedCertificates;
            KeyExportable = keyExportable;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecretsManagementSettings"/> for deserialization. </summary>
        internal SecretsManagementSettings()
        {
        }

        /// <summary> Where to store certificates on the machine. </summary>
        public string CertificateStoreLocation { get; set; }
        /// <summary> The list of certificates to install on all machines in the pool. </summary>
        public IList<Uri> ObservedCertificates { get; }
        /// <summary> Defines if the key of the certificates should be exportable. </summary>
        public bool KeyExportable { get; set; }
    }
}
