// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    public partial class SecretsManagementSettings : IUtf8JsonSerializable, IJsonModel<SecretsManagementSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecretsManagementSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecretsManagementSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecretsManagementSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecretsManagementSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CertificateStoreLocation))
            {
                writer.WritePropertyName("certificateStoreLocation"u8);
                writer.WriteStringValue(CertificateStoreLocation);
            }
            writer.WritePropertyName("observedCertificates"u8);
            writer.WriteStartArray();
            foreach (var item in ObservedCertificates)
            {
                if (item == null)
                {
                    writer.WriteNullValue();
                    continue;
                }
                writer.WriteStringValue(item.AbsoluteUri);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("keyExportable"u8);
            writer.WriteBooleanValue(KeyExportable);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SecretsManagementSettings IJsonModel<SecretsManagementSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecretsManagementSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecretsManagementSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecretsManagementSettings(document.RootElement, options);
        }

        internal static SecretsManagementSettings DeserializeSecretsManagementSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string certificateStoreLocation = default;
            IList<Uri> observedCertificates = default;
            bool keyExportable = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("certificateStoreLocation"u8))
                {
                    certificateStoreLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("observedCertificates"u8))
                {
                    List<Uri> array = new List<Uri>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(new Uri(item.GetString()));
                        }
                    }
                    observedCertificates = array;
                    continue;
                }
                if (property.NameEquals("keyExportable"u8))
                {
                    keyExportable = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecretsManagementSettings(certificateStoreLocation, observedCertificates, keyExportable, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SecretsManagementSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecretsManagementSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SecretsManagementSettings)} does not support writing '{options.Format}' format.");
            }
        }

        SecretsManagementSettings IPersistableModel<SecretsManagementSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecretsManagementSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecretsManagementSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecretsManagementSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecretsManagementSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
