// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Determines how the stand-by scheme should be provided. </summary>
    internal readonly partial struct ResourcePredictionsProfileType : IEquatable<ResourcePredictionsProfileType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourcePredictionsProfileType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourcePredictionsProfileType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> Customer provides the stand-by agent scheme. </summary>
        public static ResourcePredictionsProfileType Manual { get; } = new ResourcePredictionsProfileType(ManualValue);
        /// <summary> The stand-by agent scheme is determined based on historical demand. </summary>
        public static ResourcePredictionsProfileType Automatic { get; } = new ResourcePredictionsProfileType(AutomaticValue);
        /// <summary> Determines if two <see cref="ResourcePredictionsProfileType"/> values are the same. </summary>
        public static bool operator ==(ResourcePredictionsProfileType left, ResourcePredictionsProfileType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourcePredictionsProfileType"/> values are not the same. </summary>
        public static bool operator !=(ResourcePredictionsProfileType left, ResourcePredictionsProfileType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourcePredictionsProfileType"/>. </summary>
        public static implicit operator ResourcePredictionsProfileType(string value) => new ResourcePredictionsProfileType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourcePredictionsProfileType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourcePredictionsProfileType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
