// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    [PersistableModelProxy(typeof(UnknownResourcePredictionsProfile))]
    public partial class ResourcePredictionsProfile : IUtf8JsonSerializable, IJsonModel<ResourcePredictionsProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResourcePredictionsProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResourcePredictionsProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourcePredictionsProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourcePredictionsProfile)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResourcePredictionsProfile IJsonModel<ResourcePredictionsProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourcePredictionsProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourcePredictionsProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResourcePredictionsProfile(document.RootElement, options);
        }

        internal static ResourcePredictionsProfile DeserializeResourcePredictionsProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Automatic": return AutomaticResourcePredictionsProfile.DeserializeAutomaticResourcePredictionsProfile(element, options);
                    case "Manual": return ManualResourcePredictionsProfile.DeserializeManualResourcePredictionsProfile(element, options);
                }
            }
            return UnknownResourcePredictionsProfile.DeserializeUnknownResourcePredictionsProfile(element, options);
        }

        BinaryData IPersistableModel<ResourcePredictionsProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourcePredictionsProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResourcePredictionsProfile)} does not support writing '{options.Format}' format.");
            }
        }

        ResourcePredictionsProfile IPersistableModel<ResourcePredictionsProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourcePredictionsProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResourcePredictionsProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResourcePredictionsProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResourcePredictionsProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
