// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The storage account type of the OS disk. </summary>
    public readonly partial struct OSDiskStorageAccountType : IEquatable<OSDiskStorageAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OSDiskStorageAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OSDiskStorageAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string StandardSsdValue = "StandardSSD";

        /// <summary> Standard OS disk type. </summary>
        public static OSDiskStorageAccountType Standard { get; } = new OSDiskStorageAccountType(StandardValue);
        /// <summary> Premium OS disk type. </summary>
        public static OSDiskStorageAccountType Premium { get; } = new OSDiskStorageAccountType(PremiumValue);
        /// <summary> Standard SSD OS disk type. </summary>
        public static OSDiskStorageAccountType StandardSsd { get; } = new OSDiskStorageAccountType(StandardSsdValue);
        /// <summary> Determines if two <see cref="OSDiskStorageAccountType"/> values are the same. </summary>
        public static bool operator ==(OSDiskStorageAccountType left, OSDiskStorageAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OSDiskStorageAccountType"/> values are not the same. </summary>
        public static bool operator !=(OSDiskStorageAccountType left, OSDiskStorageAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OSDiskStorageAccountType"/>. </summary>
        public static implicit operator OSDiskStorageAccountType(string value) => new OSDiskStorageAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OSDiskStorageAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OSDiskStorageAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
