// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The storage profile of the VMSS. </summary>
    public partial class DevOpsStorageProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsStorageProfile"/>. </summary>
        public DevOpsStorageProfile()
        {
            DataDisks = new ChangeTrackingList<DevOpsDataDisk>();
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsStorageProfile"/>. </summary>
        /// <param name="osDiskStorageAccountType"> The Azure SKU name of the machines in the pool. </param>
        /// <param name="dataDisks"> A list of empty data disks to attach. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsStorageProfile(OSDiskStorageAccountType? osDiskStorageAccountType, IList<DevOpsDataDisk> dataDisks, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OSDiskStorageAccountType = osDiskStorageAccountType;
            DataDisks = dataDisks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure SKU name of the machines in the pool. </summary>
        public OSDiskStorageAccountType? OSDiskStorageAccountType { get; set; }
        /// <summary> A list of empty data disks to attach. </summary>
        public IList<DevOpsDataDisk> DataDisks { get; }
    }
}
