// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Stateful profile meaning that the machines will be returned to the pool after running a job. </summary>
    public partial class DevOpsStateful : DevOpsPoolAgentProfile
    {
        /// <summary> Initializes a new instance of <see cref="DevOpsStateful"/>. </summary>
        public DevOpsStateful()
        {
            Kind = "Stateful";
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsStateful"/>. </summary>
        /// <param name="kind"> Discriminator property for DevOpsPoolAgentProfile. </param>
        /// <param name="resourcePredictions"> Defines pool buffer/stand-by agents. </param>
        /// <param name="resourcePredictionsProfile">
        /// Defines how the pool buffer/stand-by agents is provided.
        /// Please note <see cref="ResourcePredictionsProfile"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AutomaticResourcePredictionsProfile"/> and <see cref="ManualResourcePredictionsProfile"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="maxAgentLifetime"> How long should stateful machines be kept around. The maximum is one week. </param>
        /// <param name="gracePeriodTimeSpan"> How long should the machine be kept around after it ran a workload when there are no stand-by agents. The maximum is one week. </param>
        internal DevOpsStateful(string kind, ResourcePredictions resourcePredictions, ResourcePredictionsProfile resourcePredictionsProfile, IDictionary<string, BinaryData> serializedAdditionalRawData, string maxAgentLifetime, string gracePeriodTimeSpan) : base(kind, resourcePredictions, resourcePredictionsProfile, serializedAdditionalRawData)
        {
            MaxAgentLifetime = maxAgentLifetime;
            GracePeriodTimeSpan = gracePeriodTimeSpan;
            Kind = kind ?? "Stateful";
        }

        /// <summary> How long should stateful machines be kept around. The maximum is one week. </summary>
        public string MaxAgentLifetime { get; set; }
        /// <summary> How long should the machine be kept around after it ran a workload when there are no stand-by agents. The maximum is one week. </summary>
        public string GracePeriodTimeSpan { get; set; }
    }
}
