// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The VM image of the machines in the pool. </summary>
    public partial class DevOpsPoolVmImage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsPoolVmImage"/>. </summary>
        public DevOpsPoolVmImage()
        {
            Aliases = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsPoolVmImage"/>. </summary>
        /// <param name="resourceId"> The resource id of the image. </param>
        /// <param name="wellKnownImageName"> The image to use from a well-known set of images made available to customers. </param>
        /// <param name="aliases"> List of aliases to reference the image by. </param>
        /// <param name="buffer"> The percentage of the buffer to be allocated to this image. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsPoolVmImage(string resourceId, string wellKnownImageName, IList<string> aliases, string buffer, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            WellKnownImageName = wellKnownImageName;
            Aliases = aliases;
            Buffer = buffer;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource id of the image. </summary>
        public string ResourceId { get; set; }
        /// <summary> The image to use from a well-known set of images made available to customers. </summary>
        public string WellKnownImageName { get; set; }
        /// <summary> List of aliases to reference the image by. </summary>
        public IList<string> Aliases { get; }
        /// <summary> The percentage of the buffer to be allocated to this image. </summary>
        public string Buffer { get; set; }
    }
}
