// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    public partial class DevOpsPoolProperties : IUtf8JsonSerializable, IJsonModel<DevOpsPoolProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DevOpsPoolProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DevOpsPoolProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevOpsPoolProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevOpsPoolProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WritePropertyName("maximumConcurrency"u8);
            writer.WriteNumberValue(MaximumConcurrency);
            writer.WritePropertyName("organizationProfile"u8);
            writer.WriteObjectValue(OrganizationProfile, options);
            writer.WritePropertyName("agentProfile"u8);
            writer.WriteObjectValue(AgentProfile, options);
            writer.WritePropertyName("fabricProfile"u8);
            writer.WriteObjectValue(FabricProfile, options);
            writer.WritePropertyName("devCenterProjectResourceId"u8);
            writer.WriteStringValue(DevCenterProjectResourceId);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DevOpsPoolProperties IJsonModel<DevOpsPoolProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevOpsPoolProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevOpsPoolProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDevOpsPoolProperties(document.RootElement, options);
        }

        internal static DevOpsPoolProperties DeserializeDevOpsPoolProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DevOpsInfrastructureProvisioningState? provisioningState = default;
            int maximumConcurrency = default;
            DevOpsOrganizationProfile organizationProfile = default;
            DevOpsPoolAgentProfile agentProfile = default;
            DevOpsFabricProfile fabricProfile = default;
            string devCenterProjectResourceId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new DevOpsInfrastructureProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("maximumConcurrency"u8))
                {
                    maximumConcurrency = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("organizationProfile"u8))
                {
                    organizationProfile = DevOpsOrganizationProfile.DeserializeDevOpsOrganizationProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("agentProfile"u8))
                {
                    agentProfile = DevOpsPoolAgentProfile.DeserializeDevOpsPoolAgentProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("fabricProfile"u8))
                {
                    fabricProfile = DevOpsFabricProfile.DeserializeDevOpsFabricProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("devCenterProjectResourceId"u8))
                {
                    devCenterProjectResourceId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DevOpsPoolProperties(
                provisioningState,
                maximumConcurrency,
                organizationProfile,
                agentProfile,
                fabricProfile,
                devCenterProjectResourceId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DevOpsPoolProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevOpsPoolProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DevOpsPoolProperties)} does not support writing '{options.Format}' format.");
            }
        }

        DevOpsPoolProperties IPersistableModel<DevOpsPoolProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevOpsPoolProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDevOpsPoolProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DevOpsPoolProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DevOpsPoolProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
