// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The network profile of the machines in the pool. </summary>
    internal partial class DevOpsNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsNetworkProfile"/>. </summary>
        /// <param name="subnetId"> The subnet id on which to put all machines created in the pool. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subnetId"/> is null. </exception>
        public DevOpsNetworkProfile(string subnetId)
        {
            Argument.AssertNotNull(subnetId, nameof(subnetId));

            SubnetId = subnetId;
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsNetworkProfile"/>. </summary>
        /// <param name="subnetId"> The subnet id on which to put all machines created in the pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsNetworkProfile(string subnetId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubnetId = subnetId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsNetworkProfile"/> for deserialization. </summary>
        internal DevOpsNetworkProfile()
        {
        }

        /// <summary> The subnet id on which to put all machines created in the pool. </summary>
        public string SubnetId { get; set; }
    }
}
