// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Determines how the service should be run. </summary>
    public readonly partial struct DevOpsLogonType : IEquatable<DevOpsLogonType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevOpsLogonType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevOpsLogonType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServiceValue = "Service";
        private const string InteractiveValue = "Interactive";

        /// <summary> Run as a service. </summary>
        public static DevOpsLogonType Service { get; } = new DevOpsLogonType(ServiceValue);
        /// <summary> Run in interactive mode. </summary>
        public static DevOpsLogonType Interactive { get; } = new DevOpsLogonType(InteractiveValue);
        /// <summary> Determines if two <see cref="DevOpsLogonType"/> values are the same. </summary>
        public static bool operator ==(DevOpsLogonType left, DevOpsLogonType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevOpsLogonType"/> values are not the same. </summary>
        public static bool operator !=(DevOpsLogonType left, DevOpsLogonType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevOpsLogonType"/>. </summary>
        public static implicit operator DevOpsLogonType(string value) => new DevOpsLogonType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevOpsLogonType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevOpsLogonType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
