// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The status of the current operation. </summary>
    public readonly partial struct DevOpsInfrastructureProvisioningState : IEquatable<DevOpsInfrastructureProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevOpsInfrastructureProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevOpsInfrastructureProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string AcceptedValue = "Accepted";

        /// <summary> Represents a succeeded operation. </summary>
        public static DevOpsInfrastructureProvisioningState Succeeded { get; } = new DevOpsInfrastructureProvisioningState(SucceededValue);
        /// <summary> Represents a failed operation. </summary>
        public static DevOpsInfrastructureProvisioningState Failed { get; } = new DevOpsInfrastructureProvisioningState(FailedValue);
        /// <summary> Represents a canceled operation. </summary>
        public static DevOpsInfrastructureProvisioningState Canceled { get; } = new DevOpsInfrastructureProvisioningState(CanceledValue);
        /// <summary> Represents a pending operation. </summary>
        public static DevOpsInfrastructureProvisioningState Provisioning { get; } = new DevOpsInfrastructureProvisioningState(ProvisioningValue);
        /// <summary> Represents a pending operation. </summary>
        public static DevOpsInfrastructureProvisioningState Updating { get; } = new DevOpsInfrastructureProvisioningState(UpdatingValue);
        /// <summary> Represents an operation under deletion. </summary>
        public static DevOpsInfrastructureProvisioningState Deleting { get; } = new DevOpsInfrastructureProvisioningState(DeletingValue);
        /// <summary> Represents an accepted operation. </summary>
        public static DevOpsInfrastructureProvisioningState Accepted { get; } = new DevOpsInfrastructureProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="DevOpsInfrastructureProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DevOpsInfrastructureProvisioningState left, DevOpsInfrastructureProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevOpsInfrastructureProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DevOpsInfrastructureProvisioningState left, DevOpsInfrastructureProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevOpsInfrastructureProvisioningState"/>. </summary>
        public static implicit operator DevOpsInfrastructureProvisioningState(string value) => new DevOpsInfrastructureProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevOpsInfrastructureProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevOpsInfrastructureProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
