// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> GitHub organization profile. </summary>
    public partial class DevOpsGitHubOrganizationProfile : DevOpsOrganizationProfile
    {
        /// <summary> Initializes a new instance of <see cref="DevOpsGitHubOrganizationProfile"/>. </summary>
        /// <param name="organizations"> The list of GitHub organizations/repositories the pool should be present in. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizations"/> is null. </exception>
        public DevOpsGitHubOrganizationProfile(IEnumerable<DevOpsGitHubOrganization> organizations)
        {
            Argument.AssertNotNull(organizations, nameof(organizations));

            Organizations = organizations.ToList();
            Kind = "GitHub";
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsGitHubOrganizationProfile"/>. </summary>
        /// <param name="kind"> Discriminator property for DevOpsOrganizationProfile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="organizations"> The list of GitHub organizations/repositories the pool should be present in. </param>
        internal DevOpsGitHubOrganizationProfile(string kind, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<DevOpsGitHubOrganization> organizations) : base(kind, serializedAdditionalRawData)
        {
            Organizations = organizations;
            Kind = kind ?? "GitHub";
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsGitHubOrganizationProfile"/> for deserialization. </summary>
        internal DevOpsGitHubOrganizationProfile()
        {
        }

        /// <summary> The list of GitHub organizations/repositories the pool should be present in. </summary>
        public IList<DevOpsGitHubOrganization> Organizations { get; }
    }
}
