// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Defines a GitHub organization. </summary>
    public partial class DevOpsGitHubOrganization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsGitHubOrganization"/>. </summary>
        /// <param name="uri"> The GitHub organization URL in which the pool should be created. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        public DevOpsGitHubOrganization(Uri uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            Uri = uri;
            Repositories = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsGitHubOrganization"/>. </summary>
        /// <param name="uri"> The GitHub organization URL in which the pool should be created. </param>
        /// <param name="repositories"> Optional list of repositories in which the pool should be created. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsGitHubOrganization(Uri uri, IList<string> repositories, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Uri = uri;
            Repositories = repositories;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsGitHubOrganization"/> for deserialization. </summary>
        internal DevOpsGitHubOrganization()
        {
        }

        /// <summary> The GitHub organization URL in which the pool should be created. </summary>
        public Uri Uri { get; set; }
        /// <summary> Optional list of repositories in which the pool should be created. </summary>
        public IList<string> Repositories { get; }
    }
}
