// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The type of caching in a data disk. </summary>
    public readonly partial struct DevOpsDataDiskCachingType : IEquatable<DevOpsDataDiskCachingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevOpsDataDiskCachingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevOpsDataDiskCachingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ReadOnlyValue = "ReadOnly";
        private const string ReadWriteValue = "ReadWrite";

        /// <summary> Don't use host caching. </summary>
        public static DevOpsDataDiskCachingType None { get; } = new DevOpsDataDiskCachingType(NoneValue);
        /// <summary> For workloads that only do read operations. </summary>
        public static DevOpsDataDiskCachingType ReadOnly { get; } = new DevOpsDataDiskCachingType(ReadOnlyValue);
        /// <summary> For workloads that do a balance of read and write operations. </summary>
        public static DevOpsDataDiskCachingType ReadWrite { get; } = new DevOpsDataDiskCachingType(ReadWriteValue);
        /// <summary> Determines if two <see cref="DevOpsDataDiskCachingType"/> values are the same. </summary>
        public static bool operator ==(DevOpsDataDiskCachingType left, DevOpsDataDiskCachingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevOpsDataDiskCachingType"/> values are not the same. </summary>
        public static bool operator !=(DevOpsDataDiskCachingType left, DevOpsDataDiskCachingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevOpsDataDiskCachingType"/>. </summary>
        public static implicit operator DevOpsDataDiskCachingType(string value) => new DevOpsDataDiskCachingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevOpsDataDiskCachingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevOpsDataDiskCachingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
