// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The data disk of the VMSS. </summary>
    public partial class DevOpsDataDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsDataDisk"/>. </summary>
        public DevOpsDataDisk()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsDataDisk"/>. </summary>
        /// <param name="caching"> The type of caching to be enabled for the data disks. The default value for caching is readwrite. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. </param>
        /// <param name="diskSizeGiB"> The initial disk size in gigabytes. </param>
        /// <param name="storageAccountType"> The storage Account type to be used for the data disk. If omitted, the default is "standard_lrs". </param>
        /// <param name="driveLetter"> The drive letter for the empty data disk. If not specified, it will be the first available letter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsDataDisk(DevOpsDataDiskCachingType? caching, int? diskSizeGiB, DevOpsStorageAccountType? storageAccountType, string driveLetter, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Caching = caching;
            DiskSizeGiB = diskSizeGiB;
            StorageAccountType = storageAccountType;
            DriveLetter = driveLetter;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of caching to be enabled for the data disks. The default value for caching is readwrite. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. </summary>
        public DevOpsDataDiskCachingType? Caching { get; set; }
        /// <summary> The initial disk size in gigabytes. </summary>
        public int? DiskSizeGiB { get; set; }
        /// <summary> The storage Account type to be used for the data disk. If omitted, the default is "standard_lrs". </summary>
        public DevOpsStorageAccountType? StorageAccountType { get; set; }
        /// <summary> The drive letter for the empty data disk. If not specified, it will be the first available letter. </summary>
        public string DriveLetter { get; set; }
    }
}
