// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Determines who has admin permissions to the Azure DevOps pool. </summary>
    public readonly partial struct DevOpsAzurePermissionType : IEquatable<DevOpsAzurePermissionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevOpsAzurePermissionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevOpsAzurePermissionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InheritValue = "Inherit";
        private const string CreatorOnlyValue = "CreatorOnly";
        private const string SpecificAccountsValue = "SpecificAccounts";

        /// <summary> Pool will inherit permissions from the project or organization. </summary>
        public static DevOpsAzurePermissionType Inherit { get; } = new DevOpsAzurePermissionType(InheritValue);
        /// <summary> Only the pool creator will be an admin of the pool. </summary>
        public static DevOpsAzurePermissionType CreatorOnly { get; } = new DevOpsAzurePermissionType(CreatorOnlyValue);
        /// <summary> Only the specified accounts will be admins of the pool. </summary>
        public static DevOpsAzurePermissionType SpecificAccounts { get; } = new DevOpsAzurePermissionType(SpecificAccountsValue);
        /// <summary> Determines if two <see cref="DevOpsAzurePermissionType"/> values are the same. </summary>
        public static bool operator ==(DevOpsAzurePermissionType left, DevOpsAzurePermissionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevOpsAzurePermissionType"/> values are not the same. </summary>
        public static bool operator !=(DevOpsAzurePermissionType left, DevOpsAzurePermissionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevOpsAzurePermissionType"/>. </summary>
        public static implicit operator DevOpsAzurePermissionType(string value) => new DevOpsAzurePermissionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevOpsAzurePermissionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevOpsAzurePermissionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
