// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Defines the type of Azure DevOps pool permission. </summary>
    public partial class DevOpsAzurePermissionProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsAzurePermissionProfile"/>. </summary>
        /// <param name="kind"> Determines who has admin permissions to the Azure DevOps pool. </param>
        public DevOpsAzurePermissionProfile(DevOpsAzurePermissionType kind)
        {
            Kind = kind;
            Users = new ChangeTrackingList<string>();
            Groups = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsAzurePermissionProfile"/>. </summary>
        /// <param name="kind"> Determines who has admin permissions to the Azure DevOps pool. </param>
        /// <param name="users"> User email addresses. </param>
        /// <param name="groups"> Group email addresses. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsAzurePermissionProfile(DevOpsAzurePermissionType kind, IList<string> users, IList<string> groups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Users = users;
            Groups = groups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsAzurePermissionProfile"/> for deserialization. </summary>
        internal DevOpsAzurePermissionProfile()
        {
        }

        /// <summary> Determines who has admin permissions to the Azure DevOps pool. </summary>
        public DevOpsAzurePermissionType Kind { get; set; }
        /// <summary> User email addresses. </summary>
        public IList<string> Users { get; }
        /// <summary> Group email addresses. </summary>
        public IList<string> Groups { get; }
    }
}
