// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> Azure DevOps organization profile. </summary>
    public partial class DevOpsAzureOrganizationProfile : DevOpsOrganizationProfile
    {
        /// <summary> Initializes a new instance of <see cref="DevOpsAzureOrganizationProfile"/>. </summary>
        /// <param name="organizations"> The list of Azure DevOps organizations the pool should be present in. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizations"/> is null. </exception>
        public DevOpsAzureOrganizationProfile(IEnumerable<DevOpsOrganization> organizations)
        {
            Argument.AssertNotNull(organizations, nameof(organizations));

            Organizations = organizations.ToList();
            Kind = "AzureDevOps";
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsAzureOrganizationProfile"/>. </summary>
        /// <param name="kind"> Discriminator property for DevOpsOrganizationProfile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="organizations"> The list of Azure DevOps organizations the pool should be present in. </param>
        /// <param name="permissionProfile"> The type of permission which determines which accounts are admins on the Azure DevOps pool. </param>
        internal DevOpsAzureOrganizationProfile(string kind, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<DevOpsOrganization> organizations, DevOpsAzurePermissionProfile permissionProfile) : base(kind, serializedAdditionalRawData)
        {
            Organizations = organizations;
            PermissionProfile = permissionProfile;
            Kind = kind ?? "AzureDevOps";
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsAzureOrganizationProfile"/> for deserialization. </summary>
        internal DevOpsAzureOrganizationProfile()
        {
        }

        /// <summary> The list of Azure DevOps organizations the pool should be present in. </summary>
        public IList<DevOpsOrganization> Organizations { get; }
        /// <summary> The type of permission which determines which accounts are admins on the Azure DevOps pool. </summary>
        public DevOpsAzurePermissionProfile PermissionProfile { get; set; }
    }
}
