// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevOpsInfrastructure.Models
{
    /// <summary> The stand-by agent scheme is determined based on historical demand. </summary>
    public partial class AutomaticResourcePredictionsProfile : ResourcePredictionsProfile
    {
        /// <summary> Initializes a new instance of <see cref="AutomaticResourcePredictionsProfile"/>. </summary>
        public AutomaticResourcePredictionsProfile()
        {
            Kind = ResourcePredictionsProfileType.Automatic;
        }

        /// <summary> Initializes a new instance of <see cref="AutomaticResourcePredictionsProfile"/>. </summary>
        /// <param name="kind"> Determines how the stand-by scheme should be provided. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="predictionPreference"> Determines the balance between cost and performance. </param>
        internal AutomaticResourcePredictionsProfile(ResourcePredictionsProfileType kind, IDictionary<string, BinaryData> serializedAdditionalRawData, PredictionPreference? predictionPreference) : base(kind, serializedAdditionalRawData)
        {
            PredictionPreference = predictionPreference;
            Kind = kind;
        }

        /// <summary> Determines the balance between cost and performance. </summary>
        public PredictionPreference? PredictionPreference { get; set; }
    }
}
