// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevOpsInfrastructure
{
    internal class DevOpsPoolOperationSource : IOperationSource<DevOpsPoolResource>
    {
        private readonly ArmClient _client;

        internal DevOpsPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevOpsPoolResource IOperationSource<DevOpsPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevOpsPoolData.DeserializeDevOpsPoolData(document.RootElement);
            return new DevOpsPoolResource(_client, data);
        }

        async ValueTask<DevOpsPoolResource> IOperationSource<DevOpsPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevOpsPoolData.DeserializeDevOpsPoolData(document.RootElement);
            return new DevOpsPoolResource(_client, data);
        }
    }
}
