// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.DevOpsInfrastructure.Models;

namespace Azure.ResourceManager.DevOpsInfrastructure.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableDevOpsInfrastructureSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _devOpsPoolPoolsClientDiagnostics;
        private PoolsRestOperations _devOpsPoolPoolsRestClient;
        private ClientDiagnostics _skuClientDiagnostics;
        private SkuRestOperations _skuRestClient;
        private ClientDiagnostics _subscriptionUsagesClientDiagnostics;
        private SubscriptionUsagesRestOperations _subscriptionUsagesRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableDevOpsInfrastructureSubscriptionResource"/> class for mocking. </summary>
        protected MockableDevOpsInfrastructureSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDevOpsInfrastructureSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDevOpsInfrastructureSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics DevOpsPoolPoolsClientDiagnostics => _devOpsPoolPoolsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DevOpsInfrastructure", DevOpsPoolResource.ResourceType.Namespace, Diagnostics);
        private PoolsRestOperations DevOpsPoolPoolsRestClient => _devOpsPoolPoolsRestClient ??= new PoolsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(DevOpsPoolResource.ResourceType));
        private ClientDiagnostics SkuClientDiagnostics => _skuClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DevOpsInfrastructure", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private SkuRestOperations SkuRestClient => _skuRestClient ??= new SkuRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
        private ClientDiagnostics SubscriptionUsagesClientDiagnostics => _subscriptionUsagesClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DevOpsInfrastructure", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private SubscriptionUsagesRestOperations SubscriptionUsagesRestClient => _subscriptionUsagesRestClient ??= new SubscriptionUsagesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// List Pool resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.DevOpsInfrastructure/pools</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Pool_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-10-19</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DevOpsPoolResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DevOpsPoolResource> GetDevOpsPoolsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => DevOpsPoolPoolsRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => DevOpsPoolPoolsRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DevOpsPoolResource(Client, DevOpsPoolData.DeserializeDevOpsPoolData(e)), DevOpsPoolPoolsClientDiagnostics, Pipeline, "MockableDevOpsInfrastructureSubscriptionResource.GetDevOpsPools", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List Pool resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.DevOpsInfrastructure/pools</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Pool_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-10-19</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DevOpsPoolResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DevOpsPoolResource> GetDevOpsPools(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => DevOpsPoolPoolsRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => DevOpsPoolPoolsRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DevOpsPoolResource(Client, DevOpsPoolData.DeserializeDevOpsPoolData(e)), DevOpsPoolPoolsClientDiagnostics, Pipeline, "MockableDevOpsInfrastructureSubscriptionResource.GetDevOpsPools", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List ResourceSku resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.DevOpsInfrastructure/locations/{locationName}/skus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ResourceSku_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-10-19</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="locationName"> Name of the location. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="locationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="locationName"/> is null. </exception>
        /// <returns> An async collection of <see cref="DevOpsResourceSku"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DevOpsResourceSku> GetSkusByLocationAsync(string locationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(locationName, nameof(locationName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => SkuRestClient.CreateListByLocationRequest(Id.SubscriptionId, locationName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SkuRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, locationName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => DevOpsResourceSku.DeserializeDevOpsResourceSku(e), SkuClientDiagnostics, Pipeline, "MockableDevOpsInfrastructureSubscriptionResource.GetSkusByLocation", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List ResourceSku resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.DevOpsInfrastructure/locations/{locationName}/skus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ResourceSku_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-10-19</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="locationName"> Name of the location. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="locationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="locationName"/> is null. </exception>
        /// <returns> A collection of <see cref="DevOpsResourceSku"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DevOpsResourceSku> GetSkusByLocation(string locationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(locationName, nameof(locationName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => SkuRestClient.CreateListByLocationRequest(Id.SubscriptionId, locationName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SkuRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, locationName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => DevOpsResourceSku.DeserializeDevOpsResourceSku(e), SkuClientDiagnostics, Pipeline, "MockableDevOpsInfrastructureSubscriptionResource.GetSkusByLocation", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List Quota resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.DevOpsInfrastructure/locations/{location}/usages</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SubscriptionUsages_GetUsages</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-10-19</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DevOpsResourceQuota"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DevOpsResourceQuota> GetUsagesAsync(AzureLocation location, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SubscriptionUsagesRestClient.CreateGetUsagesRequest(Id.SubscriptionId, location);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SubscriptionUsagesRestClient.CreateGetUsagesNextPageRequest(nextLink, Id.SubscriptionId, location);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => DevOpsResourceQuota.DeserializeDevOpsResourceQuota(e), SubscriptionUsagesClientDiagnostics, Pipeline, "MockableDevOpsInfrastructureSubscriptionResource.GetUsages", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List Quota resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.DevOpsInfrastructure/locations/{location}/usages</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SubscriptionUsages_GetUsages</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-10-19</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DevOpsResourceQuota"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DevOpsResourceQuota> GetUsages(AzureLocation location, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SubscriptionUsagesRestClient.CreateGetUsagesRequest(Id.SubscriptionId, location);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SubscriptionUsagesRestClient.CreateGetUsagesNextPageRequest(nextLink, Id.SubscriptionId, location);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => DevOpsResourceQuota.DeserializeDevOpsResourceQuota(e), SubscriptionUsagesClientDiagnostics, Pipeline, "MockableDevOpsInfrastructureSubscriptionResource.GetUsages", "value", "nextLink", cancellationToken);
        }
    }
}
