// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DevOpsInfrastructure.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.DevOpsInfrastructure.Samples
{
    public partial class Sample_DevOpsPoolResource
    {
        // Pools_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PoolsGet()
        {
            // Generated from example definition: 2024-10-19/GetPool.json
            // this example is just showing the usage of "Pool_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsPoolResource created on azure
            // for more information of creating DevOpsPoolResource, please refer to the document of DevOpsPoolResource
            string subscriptionId = "a2e95d27-c161-4b61-bda4-11512c14c2c2";
            string resourceGroupName = "rg";
            string poolName = "pool";
            ResourceIdentifier devOpsPoolResourceId = DevOpsPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, poolName);
            DevOpsPoolResource devOpsPool = client.GetDevOpsPoolResource(devOpsPoolResourceId);

            // invoke the operation
            DevOpsPoolResource result = await devOpsPool.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevOpsPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Pools_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PoolsUpdate()
        {
            // Generated from example definition: 2024-10-19/UpdatePool.json
            // this example is just showing the usage of "Pool_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsPoolResource created on azure
            // for more information of creating DevOpsPoolResource, please refer to the document of DevOpsPoolResource
            string subscriptionId = "a2e95d27-c161-4b61-bda4-11512c14c2c2";
            string resourceGroupName = "rg";
            string poolName = "pool";
            ResourceIdentifier devOpsPoolResourceId = DevOpsPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, poolName);
            DevOpsPoolResource devOpsPool = client.GetDevOpsPoolResource(devOpsPoolResourceId);

            // invoke the operation
            DevOpsPoolPatch patch = new DevOpsPoolPatch();
            ArmOperation<DevOpsPoolResource> lro = await devOpsPool.UpdateAsync(WaitUntil.Completed, patch);
            DevOpsPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevOpsPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Pools_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PoolsDelete()
        {
            // Generated from example definition: 2024-10-19/DeletePool.json
            // this example is just showing the usage of "Pool_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsPoolResource created on azure
            // for more information of creating DevOpsPoolResource, please refer to the document of DevOpsPoolResource
            string subscriptionId = "a2e95d27-c161-4b61-bda4-11512c14c2c2";
            string resourceGroupName = "rg";
            string poolName = "pool";
            ResourceIdentifier devOpsPoolResourceId = DevOpsPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, poolName);
            DevOpsPoolResource devOpsPool = client.GetDevOpsPoolResource(devOpsPoolResourceId);

            // invoke the operation
            await devOpsPool.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Pools_ListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDevOpsPools_PoolsListBySubscription()
        {
            // Generated from example definition: 2024-10-19/ListPoolsBySubscription.json
            // this example is just showing the usage of "Pool_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "a2e95d27-c161-4b61-bda4-11512c14c2c2";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (DevOpsPoolResource item in subscriptionResource.GetDevOpsPoolsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevOpsPoolData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ResourceDetails_ListByPool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetResourceDetails_ResourceDetailsListByPool()
        {
            // Generated from example definition: 2024-10-19/ResourceDetails_ListByPool.json
            // this example is just showing the usage of "ResourceDetailsObject_ListByPool" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsPoolResource created on azure
            // for more information of creating DevOpsPoolResource, please refer to the document of DevOpsPoolResource
            string subscriptionId = "a2e95d27-c161-4b61-bda4-11512c14c2c2";
            string resourceGroupName = "my-resource-group";
            string poolName = "my-dev-ops-pool";
            ResourceIdentifier devOpsPoolResourceId = DevOpsPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, poolName);
            DevOpsPoolResource devOpsPool = client.GetDevOpsPoolResource(devOpsPoolResourceId);

            // invoke the operation and iterate over the result
            await foreach (DevOpsResourceDetails item in devOpsPool.GetResourceDetailsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
