// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Group connectivity details. </summary>
    public partial class GroupConnectivityInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupConnectivityInformation"/>. </summary>
        public GroupConnectivityInformation()
        {
            CustomerVisibleFqdns = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="GroupConnectivityInformation"/>. </summary>
        /// <param name="groupId"> Group ID. </param>
        /// <param name="memberName"> Member name. </param>
        /// <param name="customerVisibleFqdns"> List of customer visible FQDNs. </param>
        /// <param name="internalFqdn"> Internal FQDN. </param>
        /// <param name="redirectMapId"> Redirect map ID. </param>
        /// <param name="privateLinkServiceArmRegion"> PrivateLinkService ARM region. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupConnectivityInformation(string groupId, string memberName, IList<string> customerVisibleFqdns, string internalFqdn, string redirectMapId, AzureLocation? privateLinkServiceArmRegion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupId = groupId;
            MemberName = memberName;
            CustomerVisibleFqdns = customerVisibleFqdns;
            InternalFqdn = internalFqdn;
            RedirectMapId = redirectMapId;
            PrivateLinkServiceArmRegion = privateLinkServiceArmRegion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Group ID. </summary>
        public string GroupId { get; }
        /// <summary> Member name. </summary>
        public string MemberName { get; }
        /// <summary> List of customer visible FQDNs. </summary>
        public IList<string> CustomerVisibleFqdns { get; }
        /// <summary> Internal FQDN. </summary>
        public string InternalFqdn { get; }
        /// <summary> Redirect map ID. </summary>
        public string RedirectMapId { get; set; }
        /// <summary> PrivateLinkService ARM region. </summary>
        public AzureLocation? PrivateLinkServiceArmRegion { get; set; }
    }
}
