// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Customer-initiated diagnostic log collection storage properties. </summary>
    public partial class DiagnosticStorageProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiagnosticStorageProperties"/>. </summary>
        /// <param name="authenticationType"> Authentication Type. </param>
        /// <param name="resourceId"> ResourceId of the diagnostic storage account. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public DiagnosticStorageProperties(DiagnosticStorageAuthenticationType authenticationType, ResourceIdentifier resourceId)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            AuthenticationType = authenticationType;
            ResourceId = resourceId;
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticStorageProperties"/>. </summary>
        /// <param name="authenticationType"> Authentication Type. </param>
        /// <param name="connectionString"> ConnectionString of the diagnostic storage account. </param>
        /// <param name="resourceId"> ResourceId of the diagnostic storage account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiagnosticStorageProperties(DiagnosticStorageAuthenticationType authenticationType, string connectionString, ResourceIdentifier resourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthenticationType = authenticationType;
            ConnectionString = connectionString;
            ResourceId = resourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DiagnosticStorageProperties"/> for deserialization. </summary>
        internal DiagnosticStorageProperties()
        {
        }

        /// <summary> Authentication Type. </summary>
        public DiagnosticStorageAuthenticationType AuthenticationType { get; set; }
        /// <summary> ConnectionString of the diagnostic storage account. </summary>
        public string ConnectionString { get; set; }
        /// <summary> ResourceId of the diagnostic storage account. </summary>
        public ResourceIdentifier ResourceId { get; set; }
    }
}
